package com.openexchange.guard.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.openexchange.guard.database.Utilities;
import com.openexchange.guard.server.OxDbConn;

public class OxConfiguration {
	private static Logger logger = LoggerFactory.getLogger(OxConfiguration.class);
	final static String templid = "com.openexchange.guard.templateID";
	final static String fromEmail = "com.openexchange.guard.fromEmail";
	

    private static JsonObject getOgRequest(String prop, int cid, int id, boolean required) throws Exception {

        JsonObject result = null;
        CloseableHttpClient httpClient = OxDbConn.httpClient;
        HttpContext context = HttpClientContext.create();
        String url = "http" + (Config.backend_ssl ? "s" : "") + "://" + Config.getOxBackend() + ":" + Config.ox_backend_port + "/preliminary/configuration/v1/property/" + prop + "/" + cid + "/" + id;
        HttpGet getRequest = new HttpGet(url);
        getRequest.addHeader("accept", "application/json");
        getRequest.addHeader("Authorization", "Basic " + Config.getBasicAuthenticationEncoding());
        CloseableHttpResponse response = httpClient.execute(getRequest, context);
        if (response.getStatusLine().getStatusCode() != 200) {
        	try {
        		EntityUtils.consume(response.getEntity());
        		getRequest.releaseConnection();
        		response.close();
        	} catch (Exception e2) {
        		logger.error("unable to close http stream after error", e2);
        	}
        	if (response.getStatusLine().getStatusCode() == 404) {
        		if (required) {
        			logger.error("Unable to retrieve " + prop + " from backend, is guard.properties on OX backend setup properly?");
        		} else {
        			logger.info("Unable to retrieve " + prop + " from backend.  Consider adding to backend guard.properties file.");
        		}
        		return(null);
        	}
        	logger.error("Error getting " + prop + " from backend " + response.getStatusLine().getReasonPhrase());
            throw new Exception("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
        }
        result = getJson(response);
        EntityUtils.consume(response.getEntity());
        response.close();
        getRequest.releaseConnection();
        return (result);

    }
    

    /**
     * Format response into a JSON object
     * 
     * @param response
     * @return
     * @throws UnsupportedEncodingException
     * @throws IllegalStateException
     * @throws IOException
     */
    private static JsonObject getJson(HttpResponse response) throws UnsupportedEncodingException, IllegalStateException, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
        JsonParser parser = new JsonParser();
        JsonObject result = (JsonObject) parser.parse(reader);
        reader.close();
        return (result);
    }

    public static JsonObject getProp(String prop, int cid, int id, boolean required) throws Exception {
        return (getOgRequest(prop, cid, id, required));
    }
    
    public static int getTemplateId (int cid, int id) {
    	try {
    		if (cid < 0) return (0);
    		JsonObject tjson = getProp(templid, cid, id, true);
    		if (tjson == null) return(0);
    		if (tjson.has(templid)) {
    			return (tjson.get(templid).getAsInt());
    		} else return (0);
    	} catch (Exception ex) {
    		logger.error("Error getting custom template ID ", ex);
    		return (0);
    	}
    }
    
    public static String getFromEmail (int id, int cid) {
    	try {
    		if (cid == 0) return (null);
    		if (cid < 0) {
    			cid = -cid;
    			id = -1;
    		}
    		JsonObject tjson = getProp(fromEmail, cid, id, false);
    		if (tjson == null) return(null);
    		if (tjson.has(fromEmail)) {
    			return (tjson.get(fromEmail).getAsString());
    		} else return (null);
    	} catch (Exception ex) {
    		logger.error("Error getting from Email address for password template ", ex);
    		return (null);
    	}
    }
}
