/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.data;

import com.openexchange.osgi.data.AbstractModule;
import com.openexchange.osgi.data.DirModule;
import com.openexchange.osgi.data.OSGIManifest;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BinDirModule
extends DirModule {
    private final Set<String> exportedClasspath = new HashSet<String>();
    private final Set<String> runtimeClasspath = new HashSet<String>();

    public BinDirModule(File file) {
        super(file);
    }

    private void readFiles(File manifestFile) throws IOException {
        if (manifestFile.exists() && manifestFile.length() != 0L) {
            this.osgiManifest = new OSGIManifest(manifestFile);
            Set<String> entries = this.osgiManifest.getListEntry("Bundle-ClassPath");
            if (0 == entries.size()) {
                throw new IOException("Bundle " + this.getName() + " does not have the " + "Bundle-ClassPath" + " defined.");
            }
            for (String classpathEntry : entries) {
                if (classpathEntry.equals(".")) continue;
                this.runtimeClasspath.add(classpathEntry);
                this.exportedClasspath.add(classpathEntry);
            }
        }
    }

    @Override
    public void readLocalFiles() throws IOException {
        this.readFiles(new File(this.file, "/META-INF/MANIFEST.MF"));
    }

    @Override
    public void computeDependencies(Map<String, AbstractModule> modulesByName, Map<String, Set<AbstractModule>> modulesByPackage, Map<String, AbstractModule> modulesByFilename, boolean strict) throws Exception {
        super.computeDependencies(modulesByName, modulesByPackage, modulesByFilename, strict);
    }

    @Override
    protected Set<String> getExportedClasspath() {
        return Collections.unmodifiableSet(BinDirModule.addBundlePath(this.file, this.exportedClasspath));
    }

    @Override
    protected Set<String> getRuntimeClasspath() {
        return Collections.unmodifiableSet(BinDirModule.addBundlePath(this.file, this.runtimeClasspath));
    }
}

