/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.obs.api;


/**
 * Used for storing references to other projects.
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class ProjectReference {

    public static final ProjectReference CENTOS_5 = new ProjectReference("CentOS:CentOS-5");
    public static final ProjectReference DEBIAN_LENNY = new ProjectReference("Debian:Lenny");
    public static final ProjectReference DEBIAN_SQUEEZE = new ProjectReference("Debian:Squeeze");
    public static final ProjectReference DEBIAN_WHEEZY = new ProjectReference("Debian:Wheezy");
    public static final ProjectReference DEBIAN_JESSIE = new ProjectReference("Debian:Jessie");
    public static final ProjectReference RHEL_5 = new ProjectReference("RedHat:RHEL-5");
    public static final ProjectReference RHEL_6 = new ProjectReference("RedHat:RHEL-6");
    public static final ProjectReference RHEL_7 = new ProjectReference("RedHat:RHEL-7");
    public static final ProjectReference SLE_11 = new ProjectReference("SUSE:SLE-11");
    public static final ProjectReference SLE_12 = new ProjectReference("SUSE:SLE-12");

    private final String name;

    public ProjectReference(String name) {
        super();
        this.name = name;
    }

    public static final ProjectReference byName(DistroNaming distro) throws BuildServiceException {
        switch (distro) {
        case CentOS5:
            return CENTOS_5;
        case DebianLenny:
            return DEBIAN_LENNY;
        case DebianSqueeze:
            return DEBIAN_SQUEEZE;
        case DebianWheezy:
            return DEBIAN_WHEEZY;
        case DebianJessie:
            return DEBIAN_JESSIE;
        case RHEL5:
            return RHEL_5;
        case RHEL6:
            return RHEL_6;
        case RHEL7:
            return RHEL_7;
        case SLE_11:
            return SLE_11;
        case SLE_12:
            return SLE_12;
        default:
            throw new BuildServiceException("Unknown repository: \"" + distro + "\".");
        }
    }

    public String getName() {
        return name;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectReference)) {
            return false;
        }
        ProjectReference other = (ProjectReference) obj;
        if (name == null) {
            if (other.name != null) {
                return false;
            }
        } else if (!name.equals(other.name)) {
            return false;
        }
        return true;
    }
}
