/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2015 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.ant.tasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

/**
 * {@link ListFiles} takes a path and lists all files in that path to add them to a {@link FileSet}.
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class ListFiles extends Task {

    private String id;
    private String refId;

    public ListFiles() {
        super();
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    @Override
    public void execute() throws BuildException {
        if (id == null) {
            throw new BuildException("missing id");
        }
        if (refId == null) {
            throw new BuildException("missing refId");
        }

        Object path =  getProject().getReference(refId);
        if (path == null) {
            throw new BuildException("Unknown reference " + refId);
        }
        if (!(path instanceof Path)) {
            throw new BuildException(refId + " is not a path");
        }

        String baseDir = getProject().getProperty("basedir");
        File baseFile = new File(baseDir);
        if (!baseFile.isDirectory()) {
            throw new BuildException("${basedir} is not a directory.");
        }
        baseDir = baseFile.getAbsolutePath();
        if (!baseDir.endsWith(File.separator)) {
            baseDir += File.separator;
        }

        FileSet fileSet = new FileSet();
        fileSet.setProject(getProject());
        fileSet.setDir(baseFile);

        String[] sources = ((Path) path).list();
        for (int i = 0; i < sources.length; ++i) {
            File sourceFile = new File(sources[i]);
            list(baseDir, sourceFile, fileSet);
        }
        getProject().addReference(id, fileSet);
    }

    private void list(String baseDir, File file, FileSet fileSet) {
        if (!file.exists()) {
            throw new BuildException("Path " + file.getAbsolutePath() + " does not exist.");
        }
        if (file.isFile()) {
            fileSet.createInclude().setName(file.getAbsolutePath().substring(baseDir.length()));
        } else if (file.isDirectory()) {
            for (File tmp : file.listFiles()) {
                list(baseDir, tmp, fileSet);
            }
        } else {
            throw new BuildException("No idea what to do with " + file.getAbsolutePath());
        }
    }
}
