/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.documentconverter;

public enum Feature {

    // - Enums -----------------------------------------------------------------

    DOCUMENTCONVERTER(0x00000001),

    // you may pass a source mime type String
    // parameter to the IManager.hasFeature method,
    // in order to detect if the SharePoint service
    // is supported for this kind of source document
    SHAREPOINT_PDFCONVERSION(0x00000002),

    REMOTE_DOCUMENTCONVERTER(0x00000004);

    // - Enum implementation ---------------------------------------------------

    /**
     *
     */
    Feature(int id) {
        this.m_id = id;
    }

    /**
     * @return
     */
    public int id() {
        return m_id;
    }

    /**
     * @param feature The feature to check for existence within the ORed id
     * @param featureIds ORed value of feature ids
     * @return true, if the ORed feature id contains an id for the requested feature
     */
    public static boolean isFeatureSupported(int featuresId, Feature feature) {
        return ((featuresId & feature.id()) == feature.id());
    }

    /**
     * @param featureX var arg list of Feature arguments to calculate the ORed feature id from
     * @return The ORed feature id of all given Feature arguments
     */
    public static int getFeaturesId(Feature ... featureX) {
        int featuresId = 0;

        for (int i = 0; i < featureX.length; ++i) {
            featuresId |= featureX[i].id();
        }

        return featuresId;
    }

    // - Members ---------------------------------------------------------------

    private final int m_id;
}
