/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.documentconverter;

import java.net.URL;

//-------------------
//- CacheDescriptor -
//-------------------

/**
 * {@link CacheDescriptor}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class CacheDescriptor {

    /**
     * the path to the directory of the cache; if this directory does't exist, it will be created; the directory shouldn't contain any other
     * objects, since it is up to the implementation to remove this directory or change it in any way; the cache implementation is the owner
     * of this directory after successful initialization; the path to this directory and all contained files needs to have write permission
     * for the account of the user who owns the process
     */
    public String cacheDirectory = null;

    /**
     * the lower limit for the size of the volume that should not be occupied by the cache
     */
    public long minimumFreeVolumeSize = 0;

    /**
     * the upper limit for the size of all persistent files within the cache directory; -1 for no upper limit
     */
    public long maximumPersistSize = -1;

    /**
     * the maximum number of objects to be cached at all; -1 for no upper limit
     */
    public long maximumEntryCount = -1;

    /**
     * the timeout in milliseconds for the cached objects to be removed; 0 to disable the timeout based removal of cached objects
     */
    public long timeoutMilliseconds = 0;

    /**
     * the timeout in milliseconds for the cached objects to be removed; 0 to disable the timeout based removal of cached objects
     */
    public URL[] remoteCacheUrls = null;
}
