/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.documentconverter;

import java.net.URL;
import java.util.HashMap;

import org.apache.commons.lang.StringUtils;

/**
 * {@link Config}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
/**
 * {@link Config}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class Config {

    /**
     * the directory, containing the ./program directory of the underlying readerengine
     */
    public String ENGINE_INSTALLDIR = "/opt/readerengine";

    /**
     * the directory, containing the cache for persistent, huge job data at runtime
     */
    public String ENGINE_CACHEDIR = "/var/spool/open-xchange/documentconverter/readerengine.cache";

    /**
     * a temp. directory, containing the runtime data for each started engine process
     */
    public String ENGINE_SCRATCHDIR = "/var/spool/open-xchange/documentconverter/readerengine.scratch";

    /**
     * a temp. directory, containing files that could not be loaded due to an error condition or due to a timeout
     */
    public String ENGINE_ERRORDIR = "/var/spool/open-xchange/documentconverter/readerengine.error";

    /**
     * external URL blacklist file
     */
    public String ENGINE_URL_BLACKLIST_FILE = "/opt/open-xchange/etc/readerengine.blacklist";

    /**
     * external URL whitelist file
     */
    public String ENGINE_URL_WHITELIST_FILE = "/opt/open-xchange/etc/readerengine.whitelist";

    /**
     * external URL maximum link count
     */
    public int ENGINE_URL_LINK_LIMIT = 120;

    /**
     * proxy server for external readerengine URLs
     */
    public String ENGINE_URL_LINK_PROXY = null;

    /**
     * Base URL to be used for remote conversions; if left empty, the current backend will handle the conversions
     */
    public URL ENGINE_REMOTE_BASEURL = null;

    /**
     * Cache URL(s) to be used for remote conversions; the local backend will handle caching in every case, but a cache speedup can be
     * achieved by adding additional cache servers
     */
    public URL[] ENGINE_REMOTE_CACHEURLS = null;

    /**
     * Sharepoint URL to be used for MSO to PDF conversions; if left empty, the corresponding MSO2PDFConverter jobs will always return
     * false; a fallback behavior/call should be implemented in every case
     */
    public URL ENGINE_REMOTE_SHAREPOINTURL = null;

    /**
     * The login user name to be used for calls to the SharePoint service
     */
    public String ENGINE_REMOTE_SHAREPOINTUSERNAME = null;

    /**
     * The login password to be used for calls to the SharePoint service
     */
    public String ENGINE_REMOTE_SHAREPOINTPASSWORD = null;

    /**
     * Force usage of SharepointServer despite setting of job property (capability) on e.g. remote conversion server
     */
    public boolean ENGINE_FORCE_SHAREPOINT_CONVERSION = false;
    
    /**
     * the number of engines, working in parallel to execute SharePoint jobs;
     */
    public int ENGINE_JOB_SHAREPOINT_PROCESSOR_COUNT = 3;

    /**
     * the location of the log
     */
    public String ENGINE_LOGFILE = null;

    /**
     * determines the amount and detail of logging data; 3 = errors, 2 = errors and warnings, 1 = errors and warnings and infos, 0 =
     * disabled
     */
    public String ENGINE_LOGLEVEL = null;

    /**
     * the number of engines, working in parallel to execute jobs;
     */
    public int ENGINE_JOB_PROCESSOR_COUNT = 3;

    /**
     * the maximum number of executed jobs, after which a single engine is automatically restarted;
     */
    public int ENGINE_JOB_RESTART_COUNT = 50;

    /**     * the timeout in milliseconds, after which the execution of a single job is terminated
     */
    public long ENGINE_JOB_EXECUTION_TIMEOUT_MILLISECONDS = 60000;

    /**
     * the maximum size in MegaBytes of virtual memory that a readerengine instance can allocate; -1 for no upper limit
     */
    public long ENGINE_MAX_VMEM_MB = 2048;

    /**
     * the maximum size in MegaBytes for source files to be converted; -1 for no upper limit
     */
    public long ENGINE_MAX_SOURCEFILESIZE_MB = 128;

    /**
     * the minimum size in MegaBytes of the volume, the cache is located on, that will not be used by the cache;
     */
    public long ENGINE_MIN_FREE_VOLUMESIZE_MB = 1024;

    /**
     * the maximum size in MegaBytes of all persistently cached converter job entries at runtime; the total cache size will also take into
     * account the value for the minimum free volume size, so that at least this free volume size will not be occupied by the cache -1 for
     * no upper limit
     */
    public long ENGINE_MAX_CACHESIZE_MB = -1;

    /**
     * the maximum count of converter jobs cached at runtime; -1 for no upper limit
     */
    public long ENGINE_MAX_CACHEENTRIES = -1;

    /**
     * the timeout in seconds, after which a cached job execution result is automatically removed from the cache 0 for disabling the timeout
     * based removal
     */
    public long ENGINE_CACHEENTRY_TIMEOUT_SECONDS = 2592000;

    /**
     * the maximum size in MegaBytes of virtual memory that a PDFTool instance can allocate; -1 for no upper limit
     */
    public long PDFTOOL_MAX_VMEM_MB = 1024;

    /**
     * Flag to forbid/allow the servlet engine to handle local file:// URLS
     */
    public boolean SERVLET_ENGINE_LOCAL_FILE_URLS = false;

    /**
     * Internal flag to enable the debug mode
     */
    public boolean ENGINE_DEBUG = false;

    /**
     * the logger to be used for logging
     */
    public org.slf4j.Logger logger = null;

    /**
     * the location of the performance directory
     */
    public String ENGINE_PERFORMANCEDIR = null;

    /**
     * the timeout in milliseconds, after which an entry is removed from the errorcache
     */
    public long ENGINE_ERROR_CACHE_TIMEOUT_SECONDS = 600;

    /**
     * the max. number of cycles, a hash is added to the errorcache,
     * until it won't be removed from the errorcache anymore
     */
    public int ENGINE_ERROR_CACHE_MAX_CYCLE_COUNT = 5;

    /**
     * is cache lockup enabled for preview service
     */
    public boolean PREVIEW_ENABLE_CACHE_LOOKUP = true;
    
    // - UserData handling -----------------------------------------------------

    /**
     * set user data with the given key
     * 
     * @param key
     * @param value
     */
    public void setUserData(String key, Object value) {
    	if (!StringUtils.isEmpty(key)) {
            m_userData.put(key, value);
    	}
    }

    /**
     * retrieve previously set user data with the given key
     * 
     * @param key
     * @param value
     */
    public Object getUserData(String key) {
    	Object ret = null;
    	
    	if (!StringUtils.isEmpty(key)) {
    	    ret = m_userData.get(key);
    	}
    	
    	return ret;
    }

    /**
     * additional user data to be set on demand
     */
    protected HashMap<String, Object> m_userData = new HashMap<String, Object>(8);
}
