/*
 *
 *  Copyright (C) 2012 Open-Xchange, Inc. All rights reserved.
 *
 *  This program is proprietary software and licensed to you under Open-Xchange
 *  Inc's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks of
 *  the Open-Xchange, Inc. group of companies.
 *
 */

package com.openexchange.documentconverter;


//-------------
//- JobStatus -
//-------------

/**
 * {@link JobError}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public enum JobError {
    NONE			(JobError.ERRORCODE_NONE),
    GENERAL			(JobError.ERRORCODE_GENERAL),
    TIMEOUT			(JobError.ERRORCODE_TIMEOUT),
    PASSWORD		(JobError.ERRORCODE_PASSWORD),
    NO_CONTENT		(JobError.ERRORCODE_NO_CONTENT),
    MAX_SOURCESIZE	(JobError.ERRORCODE_MAX_SOURCESIZE);

    /**
     * @param errorCode
     */
    private JobError(int errorCode) {
        m_errorCode = errorCode;
    }

    /**
     * @return The error code id of the enum
     */
    public int errorCode() {
        return m_errorCode;
    }

    /**
     * @param errorCode
     * @return The enum, given the error code id
     */
    public static JobError fromErrorCode(int errorCode) {
        JobError ret = NONE;

        switch (errorCode) {
        case ERRORCODE_NONE: 			ret = NONE; break;
        case ERRORCODE_GENERAL: 		ret = GENERAL; break;
        case ERRORCODE_TIMEOUT: 		ret = TIMEOUT; break;
        case ERRORCODE_PASSWORD: 		ret = PASSWORD; break;
        case ERRORCODE_NO_CONTENT: 		ret = NO_CONTENT; break;
        case ERRORCODE_MAX_SOURCESIZE: 	ret = MAX_SOURCESIZE; break;

        default: 						ret = GENERAL; break;
        }

        return ret;
    }

    // - Members ---------------------------------------------------------------

    protected int m_errorCode = ERRORCODE_NONE;

    // - Constants -------------------------------------------------------------

    // the error codes to be mapped to enums and vice versa
    final protected static int ERRORCODE_NONE 			= 0x00000000;
    final protected static int ERRORCODE_GENERAL 		= 0x00000001;
    final protected static int ERRORCODE_TIMEOUT 		= 0x00000002;
    final protected static int ERRORCODE_PASSWORD 		= 0x00000004;
    final protected static int ERRORCODE_NO_CONTENT 	= 0x00000008;
    final protected static int ERRORCODE_MAX_SOURCESIZE = 0x00000010;
}
