/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.documentconverter;

/**
 * {@link Properties}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class Properties {

    static final public String INFO_PREFIX = "info_";

    // -------------------------------------------------------------------------

    static final public String PROP_CACHE_PERSIST_ENTRY_NAME = "EntryName"; // String

    static final public String PROP_CACHE_HASH = "CacheHash"; // String

    static final public String PROP_INPUTFILE_HASH = "InputFileHash"; // String

    static final public String PROP_LOCALE = "Locale"; // String

    static final public String PROP_CACHE_PROPERTIES_FILENAME = "properties"; // String

    static final public String PROP_CACHE_RESULT_FILENAME = "result"; // String

    static final public String PROP_FILTER_SHORT_NAME = "FilterShortName"; // String

    static final public String PROP_IMANAGER = "IManager"; // IManager

    static final public String PROP_IMAGE_RESOLUTION = "ImageResolution"; // Integer

    static final public String PROP_IMAGE_SCALE_TYPE = "ImageScaleType"; // String

    static final public String PROP_PIXEL_WIDTH = "PixelWidth"; // Integer

    static final public String PROP_PIXEL_HEIGHT = "PixelHeight"; // Integer

    static final public String PROP_INPUT_FILE = "InputFile"; // File

    static final public String PROP_INPUT_STREAM = "InputStream"; // InputStream

    static final public String PROP_INPUT_TYPE = "InputType"; // String

    static final public String PROP_JOBID = "JobId"; // String

    static final public String PROP_JOBTYPE = "JobType"; // String

    static final public String PROP_MIME_TYPE = "MimeType"; // String

    static final public String PROP_OUTPUT_FILE = "OutputFile"; // File

    static final public String PROP_PAGE_NUMBER = "PageNumber"; // Integer

    static final public String PROP_PAGE_RANGE = "PageRange"; // String

    static final public String PROP_ZIP_ARCHIVE = "ZipArchive"; // Boolean

    static final public String PROP_PRIORITY = "Priority"; // JobPriority

    static final public String PROP_READERENGINE_ROOT = "ReaderEngineRoot"; // String

    static final public String PROP_READERENGINE_REMOTEURL = "ReaderEngineRemoteUrl"; // String

    static final public String PROP_REMOTE_METHOD = "Method"; // String

    static final public String PROP_INFO_FILENAME = INFO_PREFIX + "Filename"; // String

    static final public String PROP_FEATURES_ID = "FeaturesId"; // Integer

    static final public String PROP_CONVERTER_COOKIE = "ConverterCookie"; // String

    // -------------------------------------------------------------------------

    static final public String PROP_RESULT_CACHE_HASH = PROP_CACHE_HASH; // String

    static final public String PROP_RESULT_INPUTFILE_HASH = PROP_INPUTFILE_HASH; // String

    static final public String PROP_RESULT_LOCALE = PROP_LOCALE; // String

    static final public String PROP_RESULT_ERROR_CODE = "ErrorCode"; // Integer

    static final public String PROP_RESULT_EXTENSION = "Extension"; // String

    static final public String PROP_RESULT_BUFFER = "ResultBuffer"; // byte[]

    static final public String PROP_RESULT_JOBID = PROP_JOBID; // String

    static final public String PROP_RESULT_MIME_TYPE = PROP_MIME_TYPE; // String

    static final public String PROP_RESULT_PAGE_COUNT = "PageCount"; // Integer

    static final public String PROP_RESULT_ORIGINAL_PAGE_COUNT = "OriginalPageCount"; // Integer

    static final public String PROP_RESULT_PAGE_NUMBER = PROP_PAGE_NUMBER; // Integer

    static final public String PROP_RESULT_PASSWORD_PROTECTED = "PasswordProtected"; // Boolean

    static final public String PROP_RESULT_NO_DOCUMENT_CONTENT = "NoDocumentContent"; // Boolean

    static final public String PROP_RESULT_TEMP_INPUT_FILE = "TempInputFile"; // File

    static final public String PROP_RESULT_SINGLE_PAGE_JOBTYPE = "SinglePageJobType"; // String

    static final public String PROP_RESULT_ZIP_ARCHIVE = PROP_ZIP_ARCHIVE; // Boolean

    static final public String PROP_RESULT_CACHE_REMOTEURL = "CacheRemoteUrl"; // String

    static final public String PROP_RESULT_CONVERTER_COOKIE = PROP_CONVERTER_COOKIE; // String

    // -------------------------------------------------------------------------

    static public final String OX_RESCUEDOCUMENT_EXTENSION_APPENDIX = "_ox";

    static public final String OX_DOCUMENTCONVERTER_TEMPDIR_NAME = "oxdc.tmp";
}
