Name:          open-xchange-documentconverter-client
BuildArch:     noarch
BuildRequires: java-1.8.0-openjdk-devel
BuildRequires: ant
BuildRequires: open-xchange-documentconverter-api >= 7.10.5
Version:       7.10.5
%define        ox_release 6.0
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       AGPLv3+
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Summary:       The Open-Xchange backend client for office document conversion
AutoReqProv:   no
Requires:      open-xchange-documentconverter-api >= 7.10.5
Requires:      open-xchange-pdftool >= 1.0
Provides:      open-xchange-documentconverter = %{version}
Obsoletes:     open-xchange-documentconverter <= %{version}

%description
This package contains the backend components for the documentconverter client

Authors:
--------
    Open-Xchange

%prep

%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build

%post
if [ ${1:-0} -eq 2 ]; then
  # only when updating
  . /opt/open-xchange/lib/oxfunctions.sh

  # prevent bash from expanding, see bug 13316
  GLOBIGNORE='*'

  # SCR-234
  # SoftwareChange_Request-234
  pfile=/opt/open-xchange/etc/documentconverter-client.properties
  inst_dir_k=com.openexchange.documentconverter.client.pdfextractor.installDir
  inst_dir_v=/opt/open-xchange/sbin
  work_dir_k=com.openexchange.documentconverter.client.pdfextractor.workDir
  work_dir_v=/tmp
  ox_add_property ${inst_dir_k} ${inst_dir_v} ${pfile}
  ox_add_property ${work_dir_k} ${work_dir_v} ${pfile}

  # SCR-544
  if ox_scr_todo 544
  then
    pfile=/opt/open-xchange/etc/documentconverter-client.properties
    work_dir_k=com.openexchange.documentconverter.client.pdfextractor.workDir
    value=$(ox_read_property ${work_dir_k} ${pfile})
    if [ "/tmp" = "${value//[[:space:]]/}" ]
    then
      ox_set_property ${work_dir_k} "" ${pfile}
    fi
    ox_scr_done 544
  fi

  if ox_scr_todo SCR-708
  then
    ox_add_property com.openexchange.documentconverter.client.pdfextractor.maxVMemMB 1024 /opt/open-xchange/etc/documentconverter-client.properties
    ox_scr_done SCR-708
  fi
fi

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/bundles/
/opt/open-xchange/bundles/*
%dir /opt/open-xchange/osgi/bundle.d/
/opt/open-xchange/osgi/bundle.d/*
%dir /opt/open-xchange/etc/
%config(noreplace) /opt/open-xchange/etc/documentconverter-client.properties
/opt/open-xchange/etc/security/documentconverter-client.list

%changelog
* Thu Feb 03 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-02-07 (6089)
