/* *
 *    OPEN-XCHANGE legal information
 *
 *    All intellctual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.documentconverter.client.osgi;

import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.ajax.requesthandler.crypto.CryptographicServiceAuthenticationFactory;
import com.openexchange.ajax.requesthandler.osgiservice.AJAXModuleActivator;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.documentconverter.FileIdManager;
import com.openexchange.documentconverter.HttpHelper;
import com.openexchange.documentconverter.IDocumentConverter;
import com.openexchange.documentconverter.client.impl.ClientConfig;
import com.openexchange.documentconverter.client.impl.ClientManager;
import com.openexchange.documentconverter.client.json.DocumentConverterActionFactory;
import com.openexchange.documentconverter.client.preview.DocumentConverterPreviewService;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.file.storage.composition.crypto.CryptographicAwareIDBasedFileAccessFactory;
import com.openexchange.guard.api.GuardApi;
import com.openexchange.imagetransformation.ImageTransformationService;
import com.openexchange.mail.compose.CompositionSpaceService;
import com.openexchange.net.ssl.SSLSocketFactoryProvider;
import com.openexchange.preview.InternalPreviewService;

public class DocumentConverterClientActivator extends AJAXModuleActivator {

    /**
     * Initializes a new {@link DocumentConverterClientActivator}.
     */
    public DocumentConverterClientActivator() {
        super();
    }

    /* (non-Javadoc)
     * @see com.openexchange.osgi.DeferredActivator#getNeededServices()
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { ConfigurationService.class,
            CapabilityService.class,
            IDBasedFolderAccessFactory.class,
            IDBasedFileAccessFactory.class,
            SSLSocketFactoryProvider.class
        };
    }

    /* (non-Javadoc)
     * @see com.openexchange.osgi.HousekeepingActivator#getOptionalServices()
     */
    @Override
    protected Class<?>[] getOptionalServices() {
        return new Class<?>[] {
            IDocumentConverter.class,
            ImageTransformationService.class,
            CryptographicAwareIDBasedFileAccessFactory.class,
            CryptographicServiceAuthenticationFactory.class,
            GuardApi.class
        };
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void startBundle() throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info("starting bundle: " + SERVICE_NAME);
        }

        final ConfigurationService configService = getService(ConfigurationService.class);

        if (null != configService) {
            final ClientConfig clientConfig = new ClientConfig(configService);

            // initialize HttpHelper singleton with SSL socket factory provider
            HttpHelper.newInstance(getService(SSLSocketFactoryProvider.class));

            // initialize ClientManager singleton
            final ClientManager clientManager = ClientManager.newInstance(this, clientConfig);

            // initialize FileIdDataManager singleton
            final FileIdManager fileIdManager = FileIdManager.newInstance(clientManager, clientConfig.AUTO_CLEANUP_TIMEOUT_MILLIS);

            LOG.info("Registering DocumentConverter services");
            registerService(IDocumentConverter.class, clientManager, null);
            registerService(Reloadable.class, clientManager);

            // register OfficePreviewService
            LOG.info("Registering DocumentConverterPreviewService");
            registerService(InternalPreviewService.class, new DocumentConverterPreviewService(this));

            // register DocumentConverter related Ajax handlers
            registerModule(new DocumentConverterActionFactory(this, clientManager, fileIdManager, clientConfig), "oxodocumentconverter");

            // register information bean if/when ManagementService is available
            trackService(CompositionSpaceService.class);
            openTrackers();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void stopBundle() throws Exception {
        // shutdown FileIdDataManager singleton
        final FileIdManager fileIdManager = FileIdManager.get();

        if (null != fileIdManager) {
            fileIdManager.shutdown();
        }

        FileUtils.deleteQuietly(ClientManager.get().getClientConfig().PDFEXTRACTOR_WORKDIR);
        super.stopBundle();
    }

    // - Static Members --------------------------------------------------------

    final private static Logger LOG = LoggerFactory.getLogger(ClientManager.class);

    final private static String SERVICE_NAME = "com.openexchange.documentconverter.client";

    // - Members ---------------------------------------------------------------

}
