/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.build.utils;

import com.openexchange.build.utils.Definitions;
import java.util.regex.Matcher;

public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int patch;
    private final int revision;

    public Version(int major, int minor, int patch, int revision) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.revision = revision;
    }

    public static Version parse(String version) throws Exception {
        Matcher matcher = Definitions.VERSION_AND_REVISION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new Exception("Can not parse version: \"" + version + "\".");
        }
        return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getRevision() {
        return this.revision;
    }

    @Override
    public int compareTo(Version o) {
        if (this.major != o.major) {
            return Integer.valueOf(this.major).compareTo(o.major);
        }
        if (this.minor != o.minor) {
            return Integer.valueOf(this.minor).compareTo(o.minor);
        }
        if (this.patch != o.patch) {
            return Integer.valueOf(this.patch).compareTo(o.patch);
        }
        return Integer.valueOf(this.revision).compareTo(o.revision);
    }

    public String toString() {
        return "" + this.major + "." + this.minor + "." + this.patch + "-" + this.revision;
    }
}

