/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterParams;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.TIFFTranscoder;

public class TIFFTranscoderImageIOWriteAdapter
implements TIFFTranscoder.WriteAdapter {
    public void writeImage(TIFFTranscoder tIFFTranscoder, BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        Object object;
        TranscodingHints transcodingHints = tIFFTranscoder.getTranscodingHints();
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/tiff");
        ImageWriterParams imageWriterParams = new ImageWriterParams();
        float f = tIFFTranscoder.getUserAgent().getPixelUnitToMillimeter();
        int n = (int)(25.4 / (double)f + 0.5);
        imageWriterParams.setResolution(n);
        if (transcodingHints.containsKey((Object)TIFFTranscoder.KEY_COMPRESSION_METHOD)) {
            object = (String)transcodingHints.get((Object)TIFFTranscoder.KEY_COMPRESSION_METHOD);
            if ("packbits".equals(object)) {
                imageWriterParams.setCompressionMethod("PackBits");
            } else if ("deflate".equals(object)) {
                imageWriterParams.setCompressionMethod("Deflate");
            } else if ("lzw".equals(object)) {
                imageWriterParams.setCompressionMethod("LZW");
            } else if ("jpeg".equals(object)) {
                imageWriterParams.setCompressionMethod("JPEG");
            }
        }
        try {
            object = transcoderOutput.getOutputStream();
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            int n4 = singlePixelPackedSampleModel.getNumBands();
            int[] nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = i;
            }
            PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n2, n3, n4, n2 * n4, nArray);
            FormatRed formatRed = new FormatRed(GraphicsUtil.wrap((RenderedImage)bufferedImage), (SampleModel)pixelInterleavedSampleModel);
            imageWriter.writeImage((RenderedImage)formatRed, (OutputStream)object, imageWriterParams);
            ((OutputStream)object).flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException((Exception)iOException);
        }
    }
}

