/*
 *
 *  Copyright (C) 2012 Open-Xchange, Inc. All rights reserved.
 *
 *  This program is proprietary software and licensed to you under Open-Xchange
 *  Inc's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks of
 *  the Open-Xchange, Inc. group of companies.
 *
 */

package com.openexchange.documentconverter;

import java.net.URL;

/**
 * {@link Config}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
/**
 * {@link Config}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class Config {
    /**
     * the directory, containing the ./program directory of the underlying readerengine
     */
    public String ENGINE_INSTALLDIR = "/opt/readerengine";

    /**
     * the directory, containing the cache for persistent, huge job data at runtime
     */
    public String ENGINE_CACHEDIR = "/var/spool/open-xchange/documentconverter/readerengine.cache";

    /**
     * a temp. directory, containing the runtime data for each started engine process
     */
    public String ENGINE_SCRATCHDIR = "/var/spool/open-xchange/documentconverter/readerengine.scratch";

    /**
     * Base URL to be used for remote conversions;
     * if left empty, the current backend will handle the conversions
     */
    public URL ENGINE_REMOTE_BASEURL = null;

    /**
     * Cache URL(s) to be used for remote conversions;
     * the local backend will handle caching in every case, but a cache
     * speedup can be achieved by adding additional cache servers
     */
    public URL[] ENGINE_REMOTE_CACHEURLS = null;

    /**
     * the location of the log
     */
    public String ENGINE_LOGFILE = "/var/log/open-xchange/readerengine.log";

    /**
     * determines the amount and detail of logging data;
     * 3 = errors, 2 = errors and warnings, 1 = errors and warnings and infos, 0 = disabled
     */
    public int ENGINE_LOGLEVEL = 1;

    /**
     * the number of engines, working in parallel to execute jobs;
     */
    public int ENGINE_JOB_PROCESSOR_COUNT = 3;

    /**
     * the maximum number of executed jobs, after which a single engine is automatically restarted;
     */
    public int ENGINE_JOB_RESTART_COUNT = 50;

    /**
     * the timeout in milliseconds, after which the execution of a single job is terminated
     */
    public long ENGINE_JOB_EXECUTION_TIMEOUT_MILLISECONDS = 60000;

    /**
     * the maximum size in MegaBytes of virtual memory that a readerengine instance can allocate;
     * -1 for no upper limit
     */
    public long ENGINE_MAX_VMEM_MB = 2048;

    /**
     * the minimum size in MegaBytes of the volume, the cache is located on, that will not be used by the cache;
     */
    public long ENGINE_MIN_FREE_VOLUMESIZE_MB = 1024;

    /**
     * the maximum size in MegaBytes of all persistently cached converter job entries at runtime;
     * the total cache size will also take into account the value for the minimum free volume size,
     * so that at least this free volume size will not be occupied by the cache
     * -1 for no upper limit
     */
    public long ENGINE_MAX_CACHESIZE_MB = -1;

    /**
     * the maximum count of converter jobs cached at runtime;
     * -1 for no upper limit
     */
    public long ENGINE_MAX_CACHEENTRIES = -1;

    /**
     * the timeout in seconds, after which a cached job execution result is automatically removed from the cache
     * 0 for disabling the timeout based removal
     */
    public long ENGINE_CACHEENTRY_TIMEOUT_SECONDS = 2592000;

    /**
     * Flag to forbid/allow the servlet engine to handle local file:// URLS
     */
    public boolean SERVLET_ENGINE_LOCAL_FILE_URLS = false;

    /**
     * the log4j logger to be used for logging
     */
    public org.apache.commons.logging.Log logger = null;
}
