/*
 *
 *  Copyright (C) 2012 Open-Xchange, Inc. All rights reserved.
 *
 *  This program is proprietary software and licensed to you under Open-Xchange
 *  Inc's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks of
 *  the Open-Xchange, Inc. group of companies.
 *
 */

package com.openexchange.documentconverter;

//----------------------
//- IJobStatusListener -
//----------------------

/**
 * {@link IJobStatusListener}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public interface IJobStatusListener {

    /**
     * notifies a registered JobStatusListener that the status of a Job has just changed; the current status of the Job can be retrieved
     * from the JobProcessor via the given Job id string
     *
     * @param jobIdStr
     */
    public void statusChanged(String jobIdStr);
}
