/*
 *
 *  Copyright (C) 2012 Open-Xchange, Inc. All rights reserved.
 *
 *  This program is proprietary software and licensed to you under Open-Xchange
 *  Inc's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks of
 *  the Open-Xchange, Inc. group of companies.
 *
 */

package com.openexchange.documentconverter;

import java.io.File;
import java.util.HashMap;

/**
 * {@link ICachable}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public interface ICachable {

    /**
     * @return the hash value, upon which this cache entry can be uniquely identified
     */
    public String getHash();

    /**
     * @param cacheEntryProperties the HashMap from which the current implementer may read her runtime data
     * @param cacheEntryDirectory the cache entry user directory from which the current implementer may retrieve its external data
     * @return true in case the current implementer was able to fulfill its cached read; the file directory itself musn't be renamed or
     *         removed, but its content can be changed as necessary; if the implementer couldn't fulfill the read from the cache, she
     *         returns false and the given cache structures are deleted afterwards by the caller
     */
    public boolean readFromCache(HashMap<String, Object> cacheEntryProperties, File cacheEntryDirectory);

    /**
     * @param cacheEntryProperties the HashMap to which the current implementer may write her runtime data
     * @param cacheEntryDirectory the cache entry user directory to which the current implementer may store her external data
     * @return true in case the current implementer was able to completely cache her results; the directory itself musn't be renamed or
     *         removed, but its content can be changed as necessary; if the implementer couldn't fulfill the write to the cache, she
     *         returns false and the given cache structures are deleted afterwards by the caller
     */
    public boolean writeToCache(HashMap<String, Object> cacheEntryProperties, File cacheEntryDirectory);
}
