/*
 *
 *  Copyright (C) 2012 Open-Xchange, Inc. All rights reserved.
 *
 *  This program is proprietary software and licensed to you under Open-Xchange
 *  Inc's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks of
 *  the Open-Xchange, Inc. group of companies.
 *
 */

package com.openexchange.documentconverter;

import com.sun.star.frame.XDesktop;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.XComponentContext;

//-------------
//- IInstance -
//-------------

/**
 * {@link IInstance}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public interface IInstance {

    /**
     * sychronous launch of an IInstance with the given parameters;
     *
     * @param backendtype
     * @param aInstallDir
     * @param aUserBaseDir
     * @param maxVMemMB
     * @return true in case the IInstance was successfully launched
     */
    public boolean launch(BackendType backendtype, String installDir, String userBaseDir, long maxVMemMB);

    /**
     * synchronous shutdown of a launched IInstance
     */
    public void shutdown();

    //
    /**
     * killing of a launched IInstance
     */
    public void kill();

    /**
     * @return  true if the istance was launched successfully at
     *          least once, indicating that the installation
     *          is valid in general
     */
    public boolean isValid();

    /**
     * @return  true if the instance was launched successfully
                and is currently connected to the underlying engine;
                this method might return false in case a call to launch
                was successful but a connection is not yet available
     */
    public boolean isConnected();

    /**
     * @return the ODK {@link XMultiServiceFactory} interface of the Instance
     */
    public XMultiComponentFactory getComponentFactory();

    /**
     * @return the ODK {@link XComponentContext} interface of the Instance
     */
    public XComponentContext getDefaultContext();

    /**
     * @return the ODK {@link XFilterFactory} interface of the Instance
     */
    public XMultiServiceFactory getFilterFactory();

    /**
     * @return the ODK {@link XDesktop} interface of the Instance
     */
    public XDesktop getDesktop();
}
