/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.Location;
import org.apache.batik.bridge.Messages;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMScriptElement;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.ScriptEventWrapper;
import org.apache.batik.script.Window;
import org.apache.batik.util.EncodingUtilities;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;

public class ScriptingEnvironment
extends BaseScriptingEnvironment {
    public static final String[] SVG_EVENT_ATTRS = new String[]{"onabort", "onerror", "onresize", "onscroll", "onunload", "onzoom", "onbegin", "onend", "onrepeat", "onfocusin", "onfocusout", "onactivate", "onclick", "onmousedown", "onmouseup", "onmouseover", "onmouseout", "onmousemove", "onkeypress", "onkeydown", "onkeyup"};
    public static final String[] SVG_DOM_EVENT = new String[]{"SVGAbort", "SVGError", "SVGResize", "SVGScroll", "SVGUnload", "SVGZoom", "beginEvent", "endEvent", "repeatEvent", "DOMFocusIn", "DOMFocusOut", "DOMActivate", "click", "mousedown", "mouseup", "mouseover", "mouseout", "mousemove", "keypress", "keydown", "keyup"};
    protected Timer timer = new Timer(true);
    protected UpdateManager updateManager;
    protected RunnableQueue updateRunnableQueue;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener domAttrModifiedListener;
    protected EventListener svgAbortListener = new ScriptingEventListener("onabort");
    protected EventListener svgErrorListener = new ScriptingEventListener("onerror");
    protected EventListener svgResizeListener = new ScriptingEventListener("onresize");
    protected EventListener svgScrollListener = new ScriptingEventListener("onscroll");
    protected EventListener svgUnloadListener = new ScriptingEventListener("onunload");
    protected EventListener svgZoomListener = new ScriptingEventListener("onzoom");
    protected EventListener beginListener = new ScriptingEventListener("onbegin");
    protected EventListener endListener = new ScriptingEventListener("onend");
    protected EventListener repeatListener = new ScriptingEventListener("onrepeat");
    protected EventListener focusinListener = new ScriptingEventListener("onfocusin");
    protected EventListener focusoutListener = new ScriptingEventListener("onfocusout");
    protected EventListener activateListener = new ScriptingEventListener("onactivate");
    protected EventListener clickListener = new ScriptingEventListener("onclick");
    protected EventListener mousedownListener = new ScriptingEventListener("onmousedown");
    protected EventListener mouseupListener = new ScriptingEventListener("onmouseup");
    protected EventListener mouseoverListener = new ScriptingEventListener("onmouseover");
    protected EventListener mouseoutListener = new ScriptingEventListener("onmouseout");
    protected EventListener mousemoveListener = new ScriptingEventListener("onmousemove");
    protected EventListener keypressListener = new ScriptingEventListener("onkeypress");
    protected EventListener keydownListener = new ScriptingEventListener("onkeydown");
    protected EventListener keyupListener = new ScriptingEventListener("onkeyup");
    protected EventListener[] listeners = new EventListener[]{this.svgAbortListener, this.svgErrorListener, this.svgResizeListener, this.svgScrollListener, this.svgUnloadListener, this.svgZoomListener, this.beginListener, this.endListener, this.repeatListener, this.focusinListener, this.focusoutListener, this.activateListener, this.clickListener, this.mousedownListener, this.mouseupListener, this.mouseoverListener, this.mouseoutListener, this.mousemoveListener, this.keypressListener, this.keydownListener, this.keyupListener};
    Map attrToDOMEvent = new HashMap(SVG_EVENT_ATTRS.length);
    Map attrToListener = new HashMap(SVG_EVENT_ATTRS.length);

    public ScriptingEnvironment(BridgeContext bridgeContext) {
        super(bridgeContext);
        for (int i = 0; i < SVG_EVENT_ATTRS.length; ++i) {
            this.attrToDOMEvent.put(SVG_EVENT_ATTRS[i], SVG_DOM_EVENT[i]);
            this.attrToListener.put(SVG_EVENT_ATTRS[i], this.listeners[i]);
        }
        this.updateManager = bridgeContext.getUpdateManager();
        this.updateRunnableQueue = this.updateManager.getUpdateRunnableQueue();
        this.addScriptingListeners(this.document.getDocumentElement());
        this.addDocumentListeners();
    }

    protected void addDocumentListeners() {
        this.domNodeInsertedListener = new DOMNodeInsertedListener();
        this.domNodeRemovedListener = new DOMNodeRemovedListener();
        this.domAttrModifiedListener = new DOMAttrModifiedListener();
        NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)this.document);
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedListener, false, null);
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedListener, false, null);
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedListener, false, null);
    }

    protected void removeDocumentListeners() {
        NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)this.document);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedListener, false);
    }

    @Override
    protected org.apache.batik.script.Window createWindow(Interpreter interpreter, String string) {
        return new Window(interpreter, string);
    }

    public void runEventHandler(String string, Event event, String string2, String string3) {
        Interpreter interpreter = this.getInterpreter(string2);
        if (interpreter == null) {
            return;
        }
        try {
            this.checkCompatibleScriptURL(string2, this.docPURL);
            Object object = event instanceof ScriptEventWrapper ? ((ScriptEventWrapper)((Object)event)).getEventObject() : event;
            interpreter.bindObject("event", object);
            interpreter.bindObject("evt", object);
            interpreter.evaluate(new StringReader(string), string3);
        }
        catch (IOException iOException) {
        }
        catch (InterpreterException interpreterException) {
            this.handleInterpreterException(interpreterException);
        }
        catch (SecurityException securityException) {
            this.handleSecurityException(securityException);
        }
    }

    public void interrupt() {
        this.timer.cancel();
        this.removeScriptingListeners(this.document.getDocumentElement());
        this.removeDocumentListeners();
    }

    public void addScriptingListeners(Node node) {
        if (node.getNodeType() == 1) {
            this.addScriptingListenersOn((Element)node);
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            this.addScriptingListeners(node2);
        }
    }

    protected void addScriptingListenersOn(Element element) {
        NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)element);
        if ("http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            if ("svg".equals(element.getLocalName())) {
                if (element.hasAttributeNS(null, "onabort")) {
                    nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGAbort", this.svgAbortListener, false, null);
                }
                if (element.hasAttributeNS(null, "onerror")) {
                    nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGError", this.svgErrorListener, false, null);
                }
                if (element.hasAttributeNS(null, "onresize")) {
                    nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGResize", this.svgResizeListener, false, null);
                }
                if (element.hasAttributeNS(null, "onscroll")) {
                    nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGScroll", this.svgScrollListener, false, null);
                }
                if (element.hasAttributeNS(null, "onunload")) {
                    nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGUnload", this.svgUnloadListener, false, null);
                }
                if (element.hasAttributeNS(null, "onzoom")) {
                    nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGZoom", this.svgZoomListener, false, null);
                }
            } else {
                String string = element.getLocalName();
                if (string.equals("set") || string.startsWith("animate")) {
                    if (element.hasAttributeNS(null, "onbegin")) {
                        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "beginEvent", this.beginListener, false, null);
                    }
                    if (element.hasAttributeNS(null, "onend")) {
                        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "endEvent", this.endListener, false, null);
                    }
                    if (element.hasAttributeNS(null, "onrepeat")) {
                        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "repeatEvent", this.repeatListener, false, null);
                    }
                    return;
                }
            }
        }
        if (element.hasAttributeNS(null, "onfocusin")) {
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusIn", this.focusinListener, false, null);
        }
        if (element.hasAttributeNS(null, "onfocusout")) {
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusOut", this.focusoutListener, false, null);
        }
        if (element.hasAttributeNS(null, "onactivate")) {
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMActivate", this.activateListener, false, null);
        }
        if (element.hasAttributeNS(null, "onclick")) {
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.clickListener, false, null);
        }
        if (element.hasAttributeNS(null, "onmousedown")) {
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mousedown", this.mousedownListener, false, null);
        }
        if (element.hasAttributeNS(null, "onmouseup")) {
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseup", this.mouseupListener, false, null);
        }
        if (element.hasAttributeNS(null, "onmouseover")) {
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.mouseoverListener, false, null);
        }
        if (element.hasAttributeNS(null, "onmouseout")) {
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.mouseoutListener, false, null);
        }
        if (element.hasAttributeNS(null, "onmousemove")) {
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mousemove", this.mousemoveListener, false, null);
        }
        if (element.hasAttributeNS(null, "onkeypress")) {
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "keypress", this.keypressListener, false, null);
        }
        if (element.hasAttributeNS(null, "onkeydown")) {
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "keydown", this.keydownListener, false, null);
        }
        if (element.hasAttributeNS(null, "onkeyup")) {
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "keyup", this.keyupListener, false, null);
        }
    }

    protected void removeScriptingListeners(Node node) {
        if (node.getNodeType() == 1) {
            this.removeScriptingListenersOn((Element)node);
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            this.removeScriptingListeners(node2);
        }
    }

    protected void removeScriptingListenersOn(Element element) {
        NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)element);
        if ("http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            if ("svg".equals(element.getLocalName())) {
                nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "SVGAbort", this.svgAbortListener, false);
                nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "SVGError", this.svgErrorListener, false);
                nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "SVGResize", this.svgResizeListener, false);
                nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "SVGScroll", this.svgScrollListener, false);
                nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "SVGUnload", this.svgUnloadListener, false);
                nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "SVGZoom", this.svgZoomListener, false);
            } else {
                String string = element.getLocalName();
                if (string.equals("set") || string.startsWith("animate")) {
                    nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "beginEvent", this.beginListener, false);
                    nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "endEvent", this.endListener, false);
                    nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "repeatEvent", this.repeatListener, false);
                    return;
                }
            }
        }
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusIn", this.focusinListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusOut", this.focusoutListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMActivate", this.activateListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.clickListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mousedown", this.mousedownListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseup", this.mouseupListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.mouseoverListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.mouseoutListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mousemove", this.mousemoveListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keypress", this.keypressListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keydown", this.keydownListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keyup", this.keyupListener, false);
    }

    protected void updateScriptingListeners(Element element, String string) {
        String string2 = (String)this.attrToDOMEvent.get(string);
        if (string2 == null) {
            return;
        }
        EventListener eventListener = (EventListener)this.attrToListener.get(string);
        NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)element);
        if (element.hasAttributeNS(null, string)) {
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", string2, eventListener, false, null);
        } else {
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", string2, eventListener, false);
        }
    }

    protected class ScriptingEventListener
    implements EventListener {
        protected String attribute;

        public ScriptingEventListener(String string) {
            this.attribute = string;
        }

        @Override
        public void handleEvent(Event event) {
            Element element = (Element)((Object)event.getCurrentTarget());
            String string = element.getAttributeNS(null, this.attribute);
            if (string.length() == 0) {
                return;
            }
            DocumentLoader documentLoader = ScriptingEnvironment.this.bridgeContext.getDocumentLoader();
            SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
            int n = documentLoader.getLineNumber(element);
            String string2 = Messages.formatMessage("BaseScriptingEnvironment.constant.event.script.description", new Object[]{sVGDocument.getURL(), this.attribute, new Integer(n)});
            Element element2 = element;
            while (!(element2 == null || "http://www.w3.org/2000/svg".equals(element2.getNamespaceURI()) && "svg".equals(element2.getLocalName()))) {
                element2 = SVGUtilities.getParentElement(element2);
            }
            if (element2 == null) {
                return;
            }
            String string3 = element2.getAttributeNS(null, "contentScriptType");
            ScriptingEnvironment.this.runEventHandler(string, event, string3, string2);
        }
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            if (mutationEvent.getAttrChange() != 1) {
                ScriptingEnvironment.this.updateScriptingListeners((Element)((Object)mutationEvent.getTarget()), mutationEvent.getAttrName());
            }
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            ScriptingEnvironment.this.removeScriptingListeners((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected LinkedList toExecute = new LinkedList();

        protected DOMNodeInsertedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            Node node = (Node)((Object)event.getTarget());
            ScriptingEnvironment.this.addScriptingListeners(node);
            this.gatherScriptElements(node);
            while (!this.toExecute.isEmpty()) {
                ScriptingEnvironment.this.loadScript((AbstractElement)this.toExecute.removeFirst());
            }
        }

        protected void gatherScriptElements(Node node) {
            if (node.getNodeType() == 1) {
                if (node instanceof SVGOMScriptElement) {
                    this.toExecute.add(node);
                } else {
                    for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                        this.gatherScriptElements(node);
                    }
                }
            }
        }
    }

    protected class Window
    implements org.apache.batik.script.Window {
        protected Interpreter interpreter;
        protected String language;
        protected Location location;
        static final String DEFLATE = "deflate";
        static final String GZIP = "gzip";
        static final String UTF_8 = "UTF-8";

        public Window(Interpreter interpreter, String string) {
            this.interpreter = interpreter;
            this.language = string;
        }

        @Override
        public Object setInterval(String string, long l) {
            IntervalScriptTimerTask intervalScriptTimerTask = new IntervalScriptTimerTask(string);
            ScriptingEnvironment.this.timer.schedule((TimerTask)intervalScriptTimerTask, l, l);
            return intervalScriptTimerTask;
        }

        @Override
        public Object setInterval(Runnable runnable, long l) {
            IntervalRunnableTimerTask intervalRunnableTimerTask = new IntervalRunnableTimerTask(runnable);
            ScriptingEnvironment.this.timer.schedule((TimerTask)intervalRunnableTimerTask, l, l);
            return intervalRunnableTimerTask;
        }

        @Override
        public void clearInterval(Object object) {
            if (object == null) {
                return;
            }
            ((TimerTask)object).cancel();
        }

        @Override
        public Object setTimeout(String string, long l) {
            TimeoutScriptTimerTask timeoutScriptTimerTask = new TimeoutScriptTimerTask(string);
            ScriptingEnvironment.this.timer.schedule((TimerTask)timeoutScriptTimerTask, l);
            return timeoutScriptTimerTask;
        }

        @Override
        public Object setTimeout(Runnable runnable, long l) {
            TimeoutRunnableTimerTask timeoutRunnableTimerTask = new TimeoutRunnableTimerTask(runnable);
            ScriptingEnvironment.this.timer.schedule((TimerTask)timeoutRunnableTimerTask, l);
            return timeoutRunnableTimerTask;
        }

        @Override
        public void clearTimeout(Object object) {
            if (object == null) {
                return;
            }
            ((TimerTask)object).cancel();
        }

        @Override
        public Node parseXML(String string, Document document) {
            Object object;
            String string2;
            Node node;
            SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
            URL uRL = null;
            if (document instanceof SVGOMDocument) {
                uRL = ((SVGOMDocument)document).getURLObject();
            }
            if (uRL == null) {
                uRL = ((SVGOMDocument)ScriptingEnvironment.this.bridgeContext.getDocument()).getURLObject();
            }
            if ((node = DOMUtilities.parseXML(string, document, string2 = uRL == null ? "" : uRL.toString(), null, null, sAXSVGDocumentFactory)) != null) {
                return node;
            }
            if (document instanceof SVGOMDocument) {
                object = new HashMap<String, String>();
                object.put("xmlns", "http://www.w3.org/2000/xmlns/");
                object.put("xmlns:xlink", "http://www.w3.org/1999/xlink");
                node = DOMUtilities.parseXML(string, document, string2, (Map)object, "svg", sAXSVGDocumentFactory);
                if (node != null) {
                    return node;
                }
            }
            object = document != null ? new SAXDocumentFactory(document.getImplementation(), XMLResourceDescriptor.getXMLParserClassName()) : new SAXDocumentFactory(new GenericDOMImplementation(), XMLResourceDescriptor.getXMLParserClassName());
            return DOMUtilities.parseXML(string, document, string2, null, null, (SAXDocumentFactory)object);
        }

        @Override
        public String printNode(Node node) {
            try {
                StringWriter stringWriter = new StringWriter();
                DOMUtilities.writeNode(node, stringWriter);
                ((Writer)stringWriter).close();
                return ((Object)stringWriter).toString();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public void getURL(String string, Window.URLResponseHandler uRLResponseHandler) {
            this.getURL(string, uRLResponseHandler, null);
        }

        @Override
        public void getURL(final String string, final Window.URLResponseHandler uRLResponseHandler, final String string2) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        int n;
                        Reader reader;
                        ParsedURL parsedURL = ((SVGOMDocument)ScriptingEnvironment.this.document).getParsedURL();
                        final ParsedURL parsedURL2 = new ParsedURL(parsedURL, string);
                        String string3 = null;
                        if (string2 != null) {
                            string3 = EncodingUtilities.javaEncoding(string2);
                            string3 = string3 == null ? string2 : string3;
                        }
                        InputStream inputStream = parsedURL2.openStream();
                        if (string3 == null) {
                            reader = new InputStreamReader(inputStream);
                        } else {
                            try {
                                reader = new InputStreamReader(inputStream, string3);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                reader = new InputStreamReader(inputStream);
                            }
                        }
                        reader = new BufferedReader(reader);
                        final StringBuffer stringBuffer = new StringBuffer();
                        char[] cArray = new char[4096];
                        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                            stringBuffer.append(cArray, 0, n);
                        }
                        reader.close();
                        ScriptingEnvironment.this.updateRunnableQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                block2: {
                                    try {
                                        uRLResponseHandler.getURLDone(true, parsedURL2.getContentType(), stringBuffer.toString());
                                    }
                                    catch (Exception exception) {
                                        if (ScriptingEnvironment.this.userAgent == null) break block2;
                                        ScriptingEnvironment.this.userAgent.displayError(exception);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        if (exception instanceof SecurityException) {
                            ScriptingEnvironment.this.userAgent.displayError(exception);
                        }
                        ScriptingEnvironment.this.updateRunnableQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                block2: {
                                    try {
                                        uRLResponseHandler.getURLDone(false, null, null);
                                    }
                                    catch (Exception exception) {
                                        if (ScriptingEnvironment.this.userAgent == null) break block2;
                                        ScriptingEnvironment.this.userAgent.displayError(exception);
                                    }
                                }
                            }
                        });
                    }
                }
            };
            thread.setPriority(1);
            thread.start();
        }

        @Override
        public void postURL(String string, String string2, Window.URLResponseHandler uRLResponseHandler) {
            this.postURL(string, string2, uRLResponseHandler, "text/plain", null);
        }

        @Override
        public void postURL(String string, String string2, Window.URLResponseHandler uRLResponseHandler, String string3) {
            this.postURL(string, string2, uRLResponseHandler, string3, null);
        }

        @Override
        public void postURL(final String string, final String string2, final Window.URLResponseHandler uRLResponseHandler, final String string3, final String string4) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        int n;
                        String string5 = ((SVGOMDocument)ScriptingEnvironment.this.document).getDocumentURI();
                        URL uRL = string5 == null ? new URL(string) : new URL(new URL(string5), string);
                        final URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setDoOutput(true);
                        uRLConnection.setDoInput(true);
                        uRLConnection.setUseCaches(false);
                        uRLConnection.setRequestProperty("Content-Type", string3);
                        OutputStream outputStream = uRLConnection.getOutputStream();
                        String string22 = null;
                        String string32 = string4;
                        if (string32 != null) {
                            if (string32.startsWith(Window.DEFLATE)) {
                                outputStream = new DeflaterOutputStream(outputStream);
                                string32 = string32.length() > Window.DEFLATE.length() ? string32.substring(Window.DEFLATE.length() + 1) : "";
                                uRLConnection.setRequestProperty("Content-Encoding", Window.DEFLATE);
                            }
                            if (string32.startsWith(Window.GZIP)) {
                                outputStream = new GZIPOutputStream(outputStream);
                                string32 = string32.length() > Window.GZIP.length() ? string32.substring(Window.GZIP.length() + 1) : "";
                                uRLConnection.setRequestProperty("Content-Encoding", Window.DEFLATE);
                            }
                            if (string32.length() != 0) {
                                string22 = EncodingUtilities.javaEncoding(string32);
                                if (string22 == null) {
                                    string22 = Window.UTF_8;
                                }
                            } else {
                                string22 = Window.UTF_8;
                            }
                        }
                        OutputStreamWriter outputStreamWriter = string22 == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, string22);
                        outputStreamWriter.write(string2);
                        ((Writer)outputStreamWriter).flush();
                        ((Writer)outputStreamWriter).close();
                        outputStream.close();
                        InputStream inputStream = uRLConnection.getInputStream();
                        string22 = Window.UTF_8;
                        Reader reader = string22 == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string22);
                        reader = new BufferedReader(reader);
                        final StringBuffer stringBuffer = new StringBuffer();
                        char[] cArray = new char[4096];
                        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                            stringBuffer.append(cArray, 0, n);
                        }
                        reader.close();
                        ScriptingEnvironment.this.updateRunnableQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                block2: {
                                    try {
                                        uRLResponseHandler.getURLDone(true, uRLConnection.getContentType(), stringBuffer.toString());
                                    }
                                    catch (Exception exception) {
                                        if (ScriptingEnvironment.this.userAgent == null) break block2;
                                        ScriptingEnvironment.this.userAgent.displayError(exception);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        if (exception instanceof SecurityException) {
                            ScriptingEnvironment.this.userAgent.displayError(exception);
                        }
                        ScriptingEnvironment.this.updateRunnableQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                block2: {
                                    try {
                                        uRLResponseHandler.getURLDone(false, null, null);
                                    }
                                    catch (Exception exception) {
                                        if (ScriptingEnvironment.this.userAgent == null) break block2;
                                        ScriptingEnvironment.this.userAgent.displayError(exception);
                                    }
                                }
                            }
                        });
                    }
                }
            };
            thread.setPriority(1);
            thread.start();
        }

        @Override
        public void alert(String string) {
            if (ScriptingEnvironment.this.userAgent != null) {
                ScriptingEnvironment.this.userAgent.showAlert(string);
            }
        }

        @Override
        public boolean confirm(String string) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showConfirm(string);
            }
            return false;
        }

        @Override
        public String prompt(String string) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showPrompt(string);
            }
            return null;
        }

        @Override
        public String prompt(String string, String string2) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showPrompt(string, string2);
            }
            return null;
        }

        @Override
        public BridgeContext getBridgeContext() {
            return ScriptingEnvironment.this.bridgeContext;
        }

        @Override
        public Interpreter getInterpreter() {
            return this.interpreter;
        }

        @Override
        public org.w3c.dom.Window getParent() {
            return null;
        }

        @Override
        public org.w3c.dom.Location getLocation() {
            if (this.location == null) {
                this.location = new Location(ScriptingEnvironment.this.bridgeContext);
            }
            return this.location;
        }

        protected class TimeoutRunnableTimerTask
        extends TimerTask {
            private Runnable r;

            public TimeoutRunnableTimerTask(Runnable runnable) {
                this.r = runnable;
            }

            @Override
            public void run() {
                ScriptingEnvironment.this.updateRunnableQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                TimeoutRunnableTimerTask.this.r.run();
                            }
                            catch (Exception exception) {
                                if (ScriptingEnvironment.this.userAgent == null) break block2;
                                ScriptingEnvironment.this.userAgent.displayError(exception);
                            }
                        }
                    }
                });
            }
        }

        protected class TimeoutScriptTimerTask
        extends TimerTask {
            private String script;

            public TimeoutScriptTimerTask(String string) {
                this.script = string;
            }

            @Override
            public void run() {
                ScriptingEnvironment.this.updateRunnableQueue.invokeLater(new EvaluateRunnable(this.script, Window.this.interpreter));
            }
        }

        protected class IntervalRunnableTimerTask
        extends TimerTask {
            protected EvaluateRunnableRunnable eihr;

            public IntervalRunnableTimerTask(Runnable runnable) {
                this.eihr = new EvaluateRunnableRunnable(runnable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EvaluateRunnableRunnable evaluateRunnableRunnable = this.eihr;
                synchronized (evaluateRunnableRunnable) {
                    if (this.eihr.count > 1) {
                        return;
                    }
                    ++this.eihr.count;
                }
                ScriptingEnvironment.this.updateRunnableQueue.invokeLater(this.eihr);
                evaluateRunnableRunnable = this.eihr;
                synchronized (evaluateRunnableRunnable) {
                    if (this.eihr.error) {
                        this.cancel();
                    }
                }
            }
        }

        protected class IntervalScriptTimerTask
        extends TimerTask {
            protected EvaluateIntervalRunnable eir;

            public IntervalScriptTimerTask(String string) {
                this.eir = new EvaluateIntervalRunnable(string, Window.this.interpreter);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = this.eir;
                synchronized (object) {
                    if (this.eir.count > 1) {
                        return;
                    }
                    ++this.eir.count;
                }
                object = ScriptingEnvironment.this.updateRunnableQueue.getIteratorLock();
                synchronized (object) {
                    if (ScriptingEnvironment.this.updateRunnableQueue.getThread() == null) {
                        this.cancel();
                        return;
                    }
                    ScriptingEnvironment.this.updateRunnableQueue.invokeLater(this.eir);
                }
                object = this.eir;
                synchronized (object) {
                    if (this.eir.error) {
                        this.cancel();
                    }
                }
            }
        }
    }

    protected class EvaluateRunnableRunnable
    implements Runnable {
        public int count;
        public boolean error;
        protected Runnable runnable;

        public EvaluateRunnableRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EvaluateRunnableRunnable evaluateRunnableRunnable = this;
            synchronized (evaluateRunnableRunnable) {
                if (this.error) {
                    return;
                }
                --this.count;
            }
            try {
                this.runnable.run();
            }
            catch (Exception exception) {
                if (ScriptingEnvironment.this.userAgent != null) {
                    ScriptingEnvironment.this.userAgent.displayError(exception);
                }
                EvaluateRunnableRunnable evaluateRunnableRunnable2 = this;
                synchronized (evaluateRunnableRunnable2) {
                    this.error = true;
                }
            }
        }
    }

    protected class EvaluateIntervalRunnable
    implements Runnable {
        public int count;
        public boolean error;
        protected Interpreter interpreter;
        protected String script;

        public EvaluateIntervalRunnable(String string, Interpreter interpreter) {
            this.interpreter = interpreter;
            this.script = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EvaluateIntervalRunnable evaluateIntervalRunnable = this;
            synchronized (evaluateIntervalRunnable) {
                if (this.error) {
                    return;
                }
                --this.count;
            }
            try {
                this.interpreter.evaluate(this.script);
            }
            catch (InterpreterException interpreterException) {
                ScriptingEnvironment.this.handleInterpreterException(interpreterException);
                EvaluateIntervalRunnable evaluateIntervalRunnable2 = this;
                synchronized (evaluateIntervalRunnable2) {
                    this.error = true;
                }
            }
            catch (Exception exception) {
                if (ScriptingEnvironment.this.userAgent != null) {
                    ScriptingEnvironment.this.userAgent.displayError(exception);
                }
                EvaluateIntervalRunnable evaluateIntervalRunnable3 = this;
                synchronized (evaluateIntervalRunnable3) {
                    this.error = true;
                }
            }
        }
    }

    protected class EvaluateRunnable
    implements Runnable {
        protected Interpreter interpreter;
        protected String script;

        public EvaluateRunnable(String string, Interpreter interpreter) {
            this.interpreter = interpreter;
            this.script = string;
        }

        @Override
        public void run() {
            try {
                this.interpreter.evaluate(this.script);
            }
            catch (InterpreterException interpreterException) {
                ScriptingEnvironment.this.handleInterpreterException(interpreterException);
            }
        }
    }
}

