/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyChangeEvent;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XFastPropertySet;
import com.sun.star.beans.XMultiPropertySet;
import com.sun.star.beans.XPropertiesChangeListener;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lib.uno.helper.ComponentBase;
import com.sun.star.lib.uno.helper.InterfaceContainer;
import com.sun.star.lib.uno.helper.MultiTypeInterfaceContainer;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Enum;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class PropertySet
extends ComponentBase
implements XPropertySet,
XFastPropertySet,
XMultiPropertySet {
    private HashMap _nameToPropertyMap;
    private HashMap _handleToPropertyMap;
    private HashMap _propertyToIdMap;
    private Property[] arProperties;
    private int lastHandle = 1;
    protected XPropertySetInfo propertySetInfo;
    protected MultiTypeInterfaceContainer aBoundLC = new MultiTypeInterfaceContainer();
    protected MultiTypeInterfaceContainer aVetoableLC = new MultiTypeInterfaceContainer();

    public PropertySet() {
        this.initMappings();
    }

    protected void registerProperty(Property prop, Object id) {
        this.putProperty(prop);
        this.assignPropertyId(prop, id);
    }

    protected void registerProperty(String name, int handle, Type type, short attributes, Object id) {
        Property p = new Property(name, handle, type, attributes);
        this.registerProperty(p, id);
    }

    protected void registerProperty(String name, Type type, short attributes, Object id) {
        Property p = new Property(name, this.lastHandle++, type, attributes);
        this.registerProperty(p, id);
    }

    protected void registerProperty(String propertyName, String memberName, short attributes) {
        Field propField = null;
        try {
            propField = this.getClass().getDeclaredField(memberName);
        }
        catch (NoSuchFieldException e) {
            throw new com.sun.star.uno.RuntimeException("there is no member variable: " + memberName);
        }
        Class<?> cl = propField.getType();
        Type t = new Type(cl);
        if (t.getTypeClass() == TypeClass.UNKNOWN) {
            throw new com.sun.star.uno.RuntimeException("the member has an unknown type: " + memberName);
        }
        Property p = new Property(propertyName, this.lastHandle++, t, attributes);
        this.registerProperty(p, memberName);
    }

    protected void registerProperty(String propertyName, short attributes) {
        this.registerProperty(propertyName, propertyName, attributes);
    }

    protected Property getProperty(String propertyName) {
        return (Property)this._nameToPropertyMap.get(propertyName);
    }

    protected Property getPropertyByHandle(int nHandle) {
        return (Property)this._handleToPropertyMap.get(new Integer(nHandle));
    }

    protected Property[] getProperties() {
        if (this.arProperties == null) {
            Collection values = this._nameToPropertyMap.values();
            this.arProperties = values.toArray(new Property[this._nameToPropertyMap.size()]);
        }
        return this.arProperties;
    }

    protected void putProperty(Property prop) {
        this._nameToPropertyMap.put(prop.Name, prop);
        if (prop.Handle != -1) {
            this._handleToPropertyMap.put(new Integer(prop.Handle), prop);
        }
    }

    protected void assignPropertyId(Property prop, Object id) {
        if (id instanceof String && !((String)id).equals("")) {
            this._propertyToIdMap.put(prop, id);
        }
    }

    protected Object getPropertyId(Property prop) {
        return this._propertyToIdMap.get(prop);
    }

    protected void initMappings() {
        this._nameToPropertyMap = new HashMap();
        this._handleToPropertyMap = new HashMap();
        this._propertyToIdMap = new HashMap();
    }

    @Override
    protected void postDisposing() {
        EventObject aEvt = new EventObject(this);
        this.aBoundLC.disposeAndClear(aEvt);
        this.aVetoableLC.disposeAndClear(aEvt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void addPropertyChangeListener(String str, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        if (this.bInDispose || this.bDisposed) return;
        if (str.length() > 0) {
            Property prop = this.getProperty(str);
            if (prop == null) {
                throw new UnknownPropertyException("Property " + str + " is unknown");
            }
            if ((prop.Attributes & 2) <= 0) return;
            this.aBoundLC.addInterface(str, xPropertyChangeListener);
            return;
        } else {
            this.listenerContainer.addInterface(XPropertyChangeListener.class, xPropertyChangeListener);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void addVetoableChangeListener(String str, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        if (this.bInDispose || this.bDisposed) return;
        if (str.length() > 0) {
            Property prop = this.getProperty(str);
            if (prop == null) {
                throw new UnknownPropertyException("Property " + str + " is unknown");
            }
            if ((prop.Attributes & 4) <= 0) return;
            this.aVetoableLC.addInterface(str, xVetoableChangeListener);
            return;
        } else {
            this.listenerContainer.addInterface(XVetoableChangeListener.class, xVetoableChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XPropertySetInfo getPropertySetInfo() {
        if (this.propertySetInfo == null) {
            PropertySet propertySet = this;
            synchronized (propertySet) {
                if (this.propertySetInfo == null) {
                    this.propertySetInfo = new PropertySetInfo();
                }
            }
        }
        return this.propertySetInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getPropertyValue(String name) throws UnknownPropertyException, WrappedTargetException {
        Object ret = null;
        if (this.bInDispose || this.bDisposed) {
            throw new DisposedException("The component has been disposed already");
        }
        Property prop = this.getProperty(name);
        if (prop == null) {
            throw new UnknownPropertyException("The property " + name + " is unknown");
        }
        PropertySet propertySet = this;
        synchronized (propertySet) {
            ret = this.getPropertyValue(prop);
        }
        if (ret == null) {
            ret = prop.Type.getTypeClass() == TypeClass.INTERFACE ? new Any(prop.Type, null) : new Any(new Type(Void.TYPE), null);
        }
        return ret;
    }

    @Override
    public synchronized void removePropertyChangeListener(String propName, XPropertyChangeListener listener) throws UnknownPropertyException, WrappedTargetException {
        if (!this.bInDispose && !this.bDisposed) {
            if (propName.length() > 0) {
                Property prop = this.getProperty(propName);
                if (prop == null) {
                    throw new UnknownPropertyException("Property " + propName + " is unknown");
                }
                this.aBoundLC.removeInterface(propName, listener);
            } else {
                this.listenerContainer.removeInterface(XPropertyChangeListener.class, listener);
            }
        }
    }

    @Override
    public synchronized void removeVetoableChangeListener(String propName, XVetoableChangeListener listener) throws UnknownPropertyException, WrappedTargetException {
        if (!this.bInDispose && !this.bDisposed) {
            if (propName.length() > 0) {
                Property prop = this.getProperty(propName);
                if (prop == null) {
                    throw new UnknownPropertyException("Property " + propName + " is unknown");
                }
                this.aVetoableLC.removeInterface(propName, listener);
            } else {
                this.listenerContainer.removeInterface(XVetoableChangeListener.class, listener);
            }
        }
    }

    @Override
    public void setPropertyValue(String name, Object value) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        Property prop = this.getProperty(name);
        if (prop == null) {
            throw new UnknownPropertyException("Property " + name + " is unknown");
        }
        this.setPropertyValue(prop, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPropertyValue(Property prop, Object value) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        if ((prop.Attributes & 0x10) == 16) {
            throw new PropertyVetoException();
        }
        boolean bVoidValue = false;
        if (value instanceof Any) {
            bVoidValue = ((Any)value).getObject() == null;
        } else {
            boolean bl = bVoidValue = value == null;
        }
        if (bVoidValue && (prop.Attributes & 1) == 0) {
            throw new IllegalArgumentException("The property must have a value; the MAYBEVOID attribute is not set!");
        }
        if (this.bInDispose || this.bDisposed) {
            throw new DisposedException("Component is already disposed");
        }
        boolean bValueOk = false;
        bValueOk = value instanceof Any ? this.checkType(((Any)value).getObject()) : this.checkType(value);
        if (!bValueOk) {
            throw new IllegalArgumentException("No valid UNO type");
        }
        boolean bConversionOk = false;
        Object[] outConvertedVal = new Object[1];
        Object[] outOldValue = new Object[1];
        PropertySet propertySet = this;
        synchronized (propertySet) {
            bConversionOk = this.convertPropertyValue(prop, outConvertedVal, outOldValue, value);
        }
        if (bConversionOk) {
            this.fire(new Property[]{prop}, outConvertedVal, outOldValue, true);
            propertySet = this;
            synchronized (propertySet) {
                this.setPropertyValueNoBroadcast(prop, outConvertedVal[0]);
            }
            this.fire(new Property[]{prop}, outConvertedVal, outOldValue, false);
        }
    }

    protected boolean convertPropertyValue(Property property, Object[] newVal, Object[] curVal, Object setVal) throws IllegalArgumentException, WrappedTargetException, UnknownPropertyException {
        boolean ret;
        block15: {
            ret = true;
            try {
                String sMember = (String)this.getPropertyId(property);
                if (sMember != null) {
                    Field propField = this.getClass().getDeclaredField(sMember);
                    if (propField != null) {
                        curVal[0] = propField.get(this);
                        Class<?> memberClass = propField.getType();
                        boolean bVoidValue = false;
                        boolean bAnyVal = setVal instanceof Any;
                        if (bAnyVal) {
                            bVoidValue = ((Any)setVal).getObject() == null;
                        } else {
                            boolean bl = bVoidValue = setVal == null;
                        }
                        if (bVoidValue && memberClass.isPrimitive()) {
                            throw new IllegalArgumentException("The implementation does not support the MAYBEVOID attribute for this property");
                        }
                        Object convObj = null;
                        if (memberClass.equals(Any.class)) {
                            if (bAnyVal) {
                                convObj = setVal;
                            } else if (setVal instanceof XInterface) {
                                XInterface xint = UnoRuntime.queryInterface(XInterface.class, setVal);
                                if (xint != null) {
                                    convObj = new Any(new Type(XInterface.class), (Object)xint);
                                }
                            } else {
                                convObj = setVal == null ? (curVal[0] == null ? new Any(new Type(), null) : new Any(((Any)curVal[0]).getType(), null)) : new Any(new Type(setVal.getClass()), setVal);
                            }
                        } else {
                            convObj = this.convert(memberClass, setVal);
                        }
                        newVal[0] = convObj;
                    }
                    break block15;
                }
                throw new UnknownPropertyException("Property " + property.Name + " is unknown");
            }
            catch (NoSuchFieldException e) {
                throw new WrappedTargetException("Field does not exist", this, e);
            }
            catch (IllegalAccessException e) {
                throw new WrappedTargetException("", this, e);
            }
        }
        return ret;
    }

    private boolean checkType(Object obj) {
        return obj == null || obj instanceof Boolean || obj instanceof Character || obj instanceof Number || obj instanceof String || obj instanceof XInterface || obj instanceof Type || obj instanceof Enum || obj.getClass().isArray();
    }

    private Object convert(Class cl, Object obj) throws IllegalArgumentException {
        Object retVal = null;
        if (obj == null || obj instanceof Any && ((Any)obj).getObject() == null) {
            retVal = null;
        } else if (cl.equals(Object.class)) {
            if (obj instanceof Any) {
                obj = ((Any)obj).getObject();
            }
            retVal = obj;
        } else if (cl.equals(Boolean.TYPE)) {
            retVal = new Boolean(AnyConverter.toBoolean(obj));
        } else if (cl.equals(Character.TYPE)) {
            retVal = new Character(AnyConverter.toChar(obj));
        } else if (cl.equals(Byte.TYPE)) {
            retVal = new Byte(AnyConverter.toByte(obj));
        } else if (cl.equals(Short.TYPE)) {
            retVal = new Short(AnyConverter.toShort(obj));
        } else if (cl.equals(Integer.TYPE)) {
            retVal = new Integer(AnyConverter.toInt(obj));
        } else if (cl.equals(Long.TYPE)) {
            retVal = new Long(AnyConverter.toLong(obj));
        } else if (cl.equals(Float.TYPE)) {
            retVal = new Float(AnyConverter.toFloat(obj));
        } else if (cl.equals(Double.TYPE)) {
            retVal = new Double(AnyConverter.toDouble(obj));
        } else if (cl.equals(String.class)) {
            retVal = AnyConverter.toString(obj);
        } else if (cl.isArray()) {
            retVal = AnyConverter.toArray(obj);
        } else if (cl.equals(Type.class)) {
            retVal = AnyConverter.toType(obj);
        } else if (cl.equals(Boolean.class)) {
            retVal = new Boolean(AnyConverter.toBoolean(obj));
        } else if (cl.equals(Character.class)) {
            retVal = new Character(AnyConverter.toChar(obj));
        } else if (cl.equals(Byte.class)) {
            retVal = new Byte(AnyConverter.toByte(obj));
        } else if (cl.equals(Short.class)) {
            retVal = new Short(AnyConverter.toShort(obj));
        } else if (cl.equals(Integer.class)) {
            retVal = new Integer(AnyConverter.toInt(obj));
        } else if (cl.equals(Long.class)) {
            retVal = new Long(AnyConverter.toLong(obj));
        } else if (cl.equals(Float.class)) {
            retVal = new Float(AnyConverter.toFloat(obj));
        } else if (cl.equals(Double.class)) {
            retVal = new Double(AnyConverter.toDouble(obj));
        } else if (XInterface.class.isAssignableFrom(cl)) {
            retVal = AnyConverter.toObject(new Type(cl), obj);
        } else if (Enum.class.isAssignableFrom(cl)) {
            retVal = AnyConverter.toObject(new Type(cl), obj);
        } else {
            throw new IllegalArgumentException("Could not convert the argument");
        }
        return retVal;
    }

    protected void setPropertyValueNoBroadcast(Property property, Object newVal) throws WrappedTargetException {
        try {
            Field propField;
            String sMember = (String)this.getPropertyId(property);
            if (sMember != null && (propField = this.getClass().getDeclaredField(sMember)) != null) {
                propField.set(this, newVal);
            }
        }
        catch (Exception e) {
            throw new WrappedTargetException("PropertySet.setPropertyValueNoBroadcast", this, e);
        }
    }

    protected Object getPropertyValue(Property property) {
        Object ret = null;
        try {
            Field propField;
            String sMember = (String)this.getPropertyId(property);
            if (sMember != null && (propField = this.getClass().getDeclaredField(sMember)) != null) {
                ret = propField.get(this);
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    protected void fire(Property[] properties, Object[] newValues, Object[] oldValues, boolean bVetoable) throws PropertyVetoException {
        int nNumProps = properties.length;
        if (nNumProps > 0) {
            Object listener;
            Iterator it;
            InterfaceContainer lc;
            int i;
            PropertyChangeEvent[] arEvts = new PropertyChangeEvent[nNumProps];
            int nAffectedProps = 0;
            for (i = 0; i < nNumProps; ++i) {
                if ((!bVetoable || (properties[i].Attributes & 4) <= 0) && (bVetoable || (properties[i].Attributes & 2) <= 0)) continue;
                arEvts[i] = new PropertyChangeEvent(this, properties[i].Name, false, properties[i].Handle, oldValues[i], newValues[i]);
                ++nAffectedProps;
            }
            for (i = 0; i < nAffectedProps; ++i) {
                lc = null;
                lc = bVetoable ? this.aVetoableLC.getContainer(arEvts[i].PropertyName) : this.aBoundLC.getContainer(arEvts[i].PropertyName);
                if (lc != null) {
                    it = lc.iterator();
                    while (it.hasNext()) {
                        listener = it.next();
                        if (bVetoable) {
                            ((XVetoableChangeListener)listener).vetoableChange(arEvts[i]);
                            continue;
                        }
                        ((XPropertyChangeListener)listener).propertyChange(arEvts[i]);
                    }
                }
                if ((lc = bVetoable ? this.listenerContainer.getContainer(XVetoableChangeListener.class) : this.listenerContainer.getContainer(XPropertyChangeListener.class)) == null) continue;
                it = lc.iterator();
                while (it.hasNext()) {
                    listener = it.next();
                    if (bVetoable) {
                        ((XVetoableChangeListener)listener).vetoableChange(arEvts[i]);
                        continue;
                    }
                    ((XPropertyChangeListener)listener).propertyChange(arEvts[i]);
                }
            }
            if (!bVetoable && nAffectedProps > 0) {
                PropertyChangeEvent[] arReduced = new PropertyChangeEvent[nAffectedProps];
                System.arraycopy(arEvts, 0, arReduced, 0, nAffectedProps);
                lc = this.listenerContainer.getContainer(XPropertiesChangeListener.class);
                if (lc != null) {
                    it = lc.iterator();
                    while (it.hasNext()) {
                        listener = (XPropertiesChangeListener)it.next();
                        listener.propertiesChange(arEvts);
                    }
                }
            }
        }
    }

    @Override
    public void setFastPropertyValue(int nHandle, Object aValue) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        Property prop = this.getPropertyByHandle(nHandle);
        if (prop == null) {
            throw new UnknownPropertyException(" The property with handle : " + nHandle + " is unknown");
        }
        this.setPropertyValue(prop, aValue);
    }

    @Override
    public Object getFastPropertyValue(int nHandle) throws UnknownPropertyException, WrappedTargetException {
        Property prop = this.getPropertyByHandle(nHandle);
        if (prop == null) {
            throw new UnknownPropertyException("The property with handle : " + nHandle + " is unknown");
        }
        return this.getPropertyValue(prop);
    }

    @Override
    public void addPropertiesChangeListener(String[] propNames, XPropertiesChangeListener listener) {
        this.listenerContainer.addInterface(XPropertiesChangeListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void firePropertiesChangeEvent(String[] propNames, XPropertiesChangeListener listener) {
        PropertyChangeEvent[] arEvents = new PropertyChangeEvent[propNames.length];
        int eventCount = 0;
        PropertySet propertySet = this;
        synchronized (propertySet) {
            for (int i = 0; i < propNames.length; ++i) {
                Property prop = this.getProperty(propNames[i]);
                if (prop == null) continue;
                Object value = null;
                try {
                    value = this.getPropertyValue(prop);
                }
                catch (Exception e) {
                    continue;
                }
                arEvents[eventCount] = new PropertyChangeEvent(this, prop.Name, false, prop.Handle, value, value);
                ++eventCount;
            }
        }
        if (eventCount > 0) {
            if (arEvents.length != eventCount) {
                PropertyChangeEvent[] arPropsTmp = new PropertyChangeEvent[eventCount];
                System.arraycopy(arEvents, 0, arPropsTmp, 0, eventCount);
                arEvents = arPropsTmp;
            }
            listener.propertiesChange(arEvents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getPropertyValues(String[] propNames) {
        Object[] arValues = new Object[propNames.length];
        PropertySet propertySet = this;
        synchronized (propertySet) {
            for (int i = 0; i < propNames.length; ++i) {
                Object value = null;
                try {
                    value = this.getPropertyValue(propNames[i]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                arValues[i] = value;
            }
        }
        return arValues;
    }

    @Override
    public void removePropertiesChangeListener(XPropertiesChangeListener xPropertiesChangeListener) {
        this.listenerContainer.removeInterface(XPropertiesChangeListener.class, xPropertiesChangeListener);
    }

    @Override
    public void setPropertyValues(String[] propNames, Object[] values) throws PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        for (int i = 0; i < propNames.length; ++i) {
            try {
                this.setPropertyValue(propNames[i], values[i]);
                continue;
            }
            catch (UnknownPropertyException e) {
                // empty catch block
            }
        }
    }

    private class PropertySetInfo
    implements XPropertySetInfo {
        private PropertySetInfo() {
        }

        @Override
        public Property[] getProperties() {
            return PropertySet.this.getProperties();
        }

        @Override
        public Property getPropertyByName(String name) throws UnknownPropertyException {
            return PropertySet.this.getProperty(name);
        }

        @Override
        public boolean hasPropertyByName(String name) {
            return PropertySet.this.getProperty(name) != null;
        }
    }
}

