/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.adapter;

import com.sun.star.io.IOException;
import com.sun.star.io.XInputStream;
import java.io.InputStream;

public class InputStreamToXInputStreamAdapter
implements XInputStream {
    private InputStream iIn;

    public InputStreamToXInputStreamAdapter(InputStream in) {
        this.iIn = in;
    }

    @Override
    public int available() throws IOException {
        int bytesAvail;
        try {
            bytesAvail = this.iIn.available();
        }
        catch (java.io.IOException e) {
            throw new IOException(e.toString());
        }
        return bytesAvail;
    }

    @Override
    public void closeInput() throws IOException {
        try {
            this.iIn.close();
        }
        catch (java.io.IOException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public int readBytes(byte[][] b, int len) throws IOException {
        boolean count = false;
        try {
            long bytesRead = 0L;
            bytesRead = len > this.iIn.available() ? (long)this.iIn.read(b[0], 0, this.iIn.available()) : (long)this.iIn.read(b[0], 0, len);
            if (bytesRead <= 0L) {
                return 0;
            }
            return (int)bytesRead;
        }
        catch (java.io.IOException e) {
            throw new IOException("reader error: " + e.toString());
        }
    }

    @Override
    public int readSomeBytes(byte[][] b, int len) throws IOException {
        boolean count = false;
        try {
            long bytesRead = 0L;
            bytesRead = len > this.iIn.available() ? (long)this.iIn.read(b[0], 0, this.iIn.available()) : (long)this.iIn.read(b[0], 0, len);
            if (bytesRead <= 0L) {
                return 0;
            }
            return (int)bytesRead;
        }
        catch (java.io.IOException e) {
            throw new IOException("reader error: " + e.toString());
        }
    }

    @Override
    public void skipBytes(int n) throws IOException {
        int tmpLongVal = n;
        try {
            int avail = this.iIn.available();
        }
        catch (java.io.IOException e) {
            throw new IOException(e.toString());
        }
        do {
            int tmpIntVal = tmpLongVal >= Integer.MAX_VALUE ? Integer.MAX_VALUE : tmpLongVal;
            tmpLongVal -= tmpIntVal;
            try {
                this.iIn.skip(tmpIntVal);
            }
            catch (java.io.IOException e) {
                throw new IOException(e.toString());
            }
        } while (tmpLongVal > 0);
    }
}

