/*
 *
 *  Copyright (C) 2012 Open-Xchange, Inc. All rights reserved.
 *
 *  This program is proprietary software and licensed to you under Open-Xchange
 *  Inc's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks of
 *  the Open-Xchange, Inc. group of companies.
 *
 */

package com.openexchange.documentconverter;

//------------------
//-  IJobProcessor -
//------------------

/**
 * {@link IJobProcessor}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public interface IJobProcessor {

    /**
     * initialization of a new JobProcessor
     *
     * @param backendDescriptors
     * @return
     */
    boolean init(BackendDescriptor[] backendDescriptors);

    /**
     * adds a new Job to the processor
     *
     * @param aServerJob
     * @return the unique id of the added job or 0 in case of failure
     */
    long addJob(IJob aServerJob);

    /**
     * removes the Job with the given id from the queue of Jobs
     *
     * @param nJobId
     */
    void removeJob(long nJobId);

    /**
     * adds a listener for JobStatus change events
     *
     * @param aListener
     */
    void addJobStatusChangeListener(IJobStatusListener aListener);

    /**
     * removes a listener for JobStatus change events
     *
     * @param aListener
     */
    void removeJobStatusChangeListener(IJobStatusListener aListener);

    /**
     * asks for the filling status of the job queue
     *
     * @return true if there are any pending jobs in the queue
     */
    boolean hasJobs();

    /**
     * returns the current status of the Job with the given id
     *
     * @param nJobId
     * @return the current status of the Job
     */
    JobStatus getJobStatus(long nJobId);

    /**
     * terminates the JobProcessor
     */
    void terminate();

    /**
     * @return true if JobProcessor is going to terminate ASAP
     */
    boolean isTerminated();
}
