/*
 *
 *  Copyright (C) 2012 Open-Xchange, Inc. All rights reserved.
 *
 *  This program is proprietary software and licensed to you under Open-Xchange
 *  Inc's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks of
 *  the Open-Xchange, Inc. group of companies.
 *
 */

package com.openexchange.documentconverter;

import java.util.HashMap;

//--------
//- IJob -
//--------

/**
 * {@link IJob}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public interface IJob {

    /**
     * this method will be called from a Instance in order to do the actual work;
     *
     * @param aInstance
     * @return true if Job was executed successfully
     * @throws com.sun.star.lang.DisposedException
     * @throws Exception
     */
    boolean execute(IInstance aInstance) throws com.sun.star.lang.DisposedException, Exception;

    /**
     * @return the current job properties
     */
    HashMap<String, Object> getJobProperties();
}
