/*
 *
 *  Copyright (C) 2012 Open-Xchange, Inc. All rights reserved.
 *
 *  This program is proprietary software and licensed to you under Open-Xchange
 *  Inc's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks of
 *  the Open-Xchange, Inc. group of companies.
 *
 */

package com.openexchange.documentconverter;

/**
 * {@link Config}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class Config {

    /**
     * the directory, containing the ./program directory of the underlying readerengine
     */
    static public String ENGINE_INSTALLDIR = "/opt/readerengine";

    /**
     * the directory, containing the cache for persistent, huge job data at runtime
     */
    static public String ENGINE_CACHEDIR = "/var/spool/open-xchange/documentconverter/readerengine.cache";

    /**
     * a temp. directory, containing the runtime data for each started engine process
     */
    static public String ENGINE_SCRATCHDIR = "/var/spool/open-xchange/documentconverter/readerengine.scratch";

    /**
     * the location of the log
     */
    static public String ENGINE_LOGFILE = "/var/log/open-xchange/readerengine.log";

    /**
     * determines the amount and detail of logging data;
     * 3 = errors, 2 = errors and warnings, 1 = errors and warnings and infos, 0 = disabled
     */
    static public int ENGINE_LOGLEVEL = 1;

    /**
     * the number of engines, working in parallel to execute jobs;
     */
    static public int ENGINE_JOB_PROCESSOR_COUNT = 3;

    /**
     * the maximum number of executed jobs, after which a single engine is automatically restarted;
     */
    static public int ENGINE_JOB_RESTART_COUNT = 16;

    /**
     * the timeout in milliseconds, after which the execution of a single job is terminated
     */
    static public long ENGINE_JOB_EXECUTION_TIMEOUT_MILLISECONDS = 60000;

    /**
     * the maximum size in MegaBytes of virtual memory that a readerengine instance can allocate;
     * -1 for no upper limit
     */
    static public long ENGINE_MAX_VMEM_MB = 2048;

    /**
     * the maximum size in MegaBytes of all persistently cached converter job entries at runtime;
     * -1 for no upper limit
     */
    static public long ENGINE_MAX_CACHESIZE_MB = 1024;

    /**
     * the maximum count of converter jobs cached at runtime;
     * -1 for no upper limit
     */
    static public long ENGINE_MAX_CACHEENTRIES = -1;

    /**
     * the timeout in seconds, after which a cached job execution result is automatically removed from the cache
     * 0 for disabling the timeout based removal
     */
    static public long ENGINE_CACHEENTRY_TIMEOUT_SECONDS = 3600;

    /**
     * Flag to forbid/allow the servlet engine to handle local file:// URLS
     */
    static public boolean SERVLET_ENGINE_LOCAL_FILE_URLS = false;
}
