/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.publisher.internal;

import com.eclipsesource.jaxrs.publisher.ApplicationConfiguration;
import com.eclipsesource.jaxrs.publisher.ServletConfiguration;
import com.eclipsesource.jaxrs.publisher.internal.Configuration;
import com.eclipsesource.jaxrs.publisher.internal.JerseyContext;
import com.eclipsesource.jaxrs.publisher.internal.ServiceContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;

public class JAXRSConnector {
    private static final String HTTP_SERVICE_PORT_PROPERTY = "org.osgi.service.http.port";
    private static final String RESOURCE_HTTP_PORT_PROPERTY = "http.port";
    private static final String DEFAULT_HTTP_PORT = "80";
    private final Object lock = new Object();
    private final ServiceContainer httpServices;
    private final ServiceContainer resources;
    private final Map<HttpService, JerseyContext> contextMap;
    private final BundleContext bundleContext;
    private final List<ServiceContainer.ServiceHolder> resourceCache;
    private ServletConfiguration servletConfiguration;
    private final ServiceContainer applicationConfigurations;
    private Configuration configuration;

    JAXRSConnector(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.configuration = new Configuration(this);
        this.httpServices = new ServiceContainer(bundleContext);
        this.resources = new ServiceContainer(bundleContext);
        this.contextMap = new HashMap<HttpService, JerseyContext>();
        this.resourceCache = new ArrayList<ServiceContainer.ServiceHolder>();
        this.applicationConfigurations = new ServiceContainer(bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConfiguration(Configuration configuration) {
        Object object = this.lock;
        synchronized (object) {
            this.configuration = configuration;
            this.doUpdateHttpServices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpService addHttpService(ServiceReference reference) {
        Object object = this.lock;
        synchronized (object) {
            return this.doAddHttpService(reference);
        }
    }

    ServletConfiguration setServletConfiguration(ServiceReference reference) {
        if (this.servletConfiguration == null) {
            this.servletConfiguration = (ServletConfiguration)this.bundleContext.getService(reference);
            this.doUpdateHttpServices();
            return this.servletConfiguration;
        }
        return null;
    }

    void unsetServletConfiguration(ServiceReference reference, ServletConfiguration service) {
        if (this.servletConfiguration == service) {
            this.servletConfiguration = null;
            this.bundleContext.ungetService(reference);
            this.doUpdateHttpServices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApplicationConfiguration addApplicationConfiguration(ServiceReference reference) {
        Object object = this.lock;
        synchronized (object) {
            ApplicationConfiguration service = (ApplicationConfiguration)this.applicationConfigurations.add(reference).getService();
            this.doUpdateHttpServices();
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeApplicationConfiguration(ServiceReference reference, ApplicationConfiguration service) {
        Object object = this.lock;
        synchronized (object) {
            this.applicationConfigurations.remove(service);
            this.doUpdateHttpServices();
        }
    }

    private void doUpdateHttpServices() {
        ServiceContainer.ServiceHolder[] services;
        ServiceContainer.ServiceHolder[] serviceHolderArray = services = this.httpServices.getServices();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceContainer.ServiceHolder serviceHolder = serviceHolderArray[n2];
            this.doRemoveHttpService((HttpService)serviceHolder.getService());
            this.doAddHttpService(serviceHolder.getReference());
            ++n2;
        }
    }

    HttpService doAddHttpService(ServiceReference reference) {
        ServiceContainer.ServiceHolder serviceHolder = this.httpServices.add(reference);
        HttpService service = (HttpService)serviceHolder.getService();
        this.contextMap.put(service, this.createJerseyContext(service, this.configuration, this.servletConfiguration));
        this.clearCache();
        return service;
    }

    private void clearCache() {
        ArrayList<ServiceContainer.ServiceHolder> cache = new ArrayList<ServiceContainer.ServiceHolder>(this.resourceCache);
        this.resourceCache.clear();
        for (ServiceContainer.ServiceHolder serviceHolder : cache) {
            this.registerResource(serviceHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHttpService(HttpService service) {
        Object object = this.lock;
        synchronized (object) {
            this.doRemoveHttpService(service);
        }
    }

    void doRemoveHttpService(HttpService service) {
        JerseyContext context = this.contextMap.remove(service);
        if (context != null) {
            this.cacheFreedResources(context);
        }
        this.httpServices.remove(service);
    }

    private void cacheFreedResources(JerseyContext context) {
        List<Object> freeResources = context.eliminate();
        for (Object resource : freeResources) {
            this.resourceCache.add(this.resources.find(resource));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object addResource(ServiceReference reference) {
        Object object = this.lock;
        synchronized (object) {
            return this.doAddResource(reference);
        }
    }

    private Object doAddResource(ServiceReference reference) {
        ServiceContainer.ServiceHolder serviceHolder = this.resources.add(reference);
        this.registerResource(serviceHolder);
        return serviceHolder.getService();
    }

    private void registerResource(ServiceContainer.ServiceHolder serviceHolder) {
        Object port = this.getPort(serviceHolder);
        this.registerResource(serviceHolder, port);
    }

    private Object getPort(ServiceContainer.ServiceHolder serviceHolder) {
        Object port = serviceHolder.getReference().getProperty(RESOURCE_HTTP_PORT_PROPERTY);
        if (port == null && (port = this.bundleContext.getProperty(HTTP_SERVICE_PORT_PROPERTY)) == null) {
            port = DEFAULT_HTTP_PORT;
        }
        return port;
    }

    private void registerResource(ServiceContainer.ServiceHolder serviceHolder, Object port) {
        HttpService service = this.findHttpServiceForPort(port);
        if (service != null) {
            JerseyContext jerseyContext = this.contextMap.get(service);
            jerseyContext.addResource(serviceHolder.getService());
        } else {
            this.cacheResource(serviceHolder);
        }
    }

    private void cacheResource(ServiceContainer.ServiceHolder serviceHolder) {
        this.resourceCache.add(serviceHolder);
    }

    private HttpService findHttpServiceForPort(Object port) {
        ServiceContainer.ServiceHolder[] serviceHolders = this.httpServices.getServices();
        HttpService result = null;
        ServiceContainer.ServiceHolder[] serviceHolderArray = serviceHolders;
        int n = serviceHolders.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceContainer.ServiceHolder serviceHolder = serviceHolderArray[n2];
            Object servicePort = this.getPort(serviceHolder);
            if (servicePort.equals(port)) {
                result = (HttpService)serviceHolder.getService();
            }
            ++n2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeResource(Object resource) {
        Object object = this.lock;
        synchronized (object) {
            this.doRemoveResource(resource);
        }
    }

    private void doRemoveResource(Object resource) {
        ServiceContainer.ServiceHolder serviceHolder = this.resources.find(resource);
        this.resourceCache.remove(serviceHolder);
        HttpService httpService = this.findHttpServiceForPort(this.getPort(serviceHolder));
        this.removeResourcesFromContext(resource, httpService);
        this.resources.remove(resource);
    }

    private void removeResourcesFromContext(Object resource, HttpService httpService) {
        JerseyContext jerseyContext = this.contextMap.get(httpService);
        if (jerseyContext != null) {
            jerseyContext.removeResource(resource);
        }
    }

    JerseyContext createJerseyContext(HttpService service, Configuration configuration, ServletConfiguration servletConfiguration) {
        return new JerseyContext(service, configuration, servletConfiguration, this.applicationConfigurations);
    }
}

