/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.op;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.OrderedJSONObject;
import com.nimbusds.openid.connect.sdk.Display;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimType;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONObject;

public class OIDCProviderMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final Issuer issuer;
    private URI authzEndpoint;
    private URI tokenEndpoint;
    private URI userInfoEndpoint;
    private URI regEndpoint;
    private URI introspectionEndpoint;
    private URI revocationEndpoint;
    private URI checkSessionIframe;
    private URI endSessionEndpoint;
    private final URI jwkSetURI;
    private Scope scope;
    private List<ResponseType> rts;
    private List<ResponseMode> rms;
    private List<GrantType> gts;
    private List<CodeChallengeMethod> codeChallengeMethods;
    private List<ACR> acrValues;
    private final List<SubjectType> subjectTypes;
    private List<ClientAuthenticationMethod> tokenEndpointAuthMethods;
    private List<JWSAlgorithm> tokenEndpointJWSAlgs;
    private List<JWSAlgorithm> requestObjectJWSAlgs;
    private List<JWEAlgorithm> requestObjectJWEAlgs;
    private List<EncryptionMethod> requestObjectJWEEncs;
    private List<JWSAlgorithm> idTokenJWSAlgs;
    private List<JWEAlgorithm> idTokenJWEAlgs;
    private List<EncryptionMethod> idTokenJWEEncs;
    private List<JWSAlgorithm> userInfoJWSAlgs;
    private List<JWEAlgorithm> userInfoJWEAlgs;
    private List<EncryptionMethod> userInfoJWEEncs;
    private List<Display> displays;
    private List<ClaimType> claimTypes;
    private List<String> claims;
    private List<LangTag> claimsLocales;
    private List<LangTag> uiLocales;
    private URI serviceDocsURI;
    private URI policyURI;
    private URI tosURI;
    private boolean claimsParamSupported = false;
    private boolean requestParamSupported = false;
    private boolean requestURIParamSupported = true;
    private boolean requireRequestURIReg = false;
    private boolean frontChannelLogoutSupported = false;
    private boolean frontChannelLogoutSessionSupported = false;
    private boolean backChannelLogoutSupported = false;
    private boolean backChannelLogoutSessionSupported = false;
    private final JSONObject customParameters = new JSONObject();

    static {
        HashSet<String> p = new HashSet<String>();
        p.add("issuer");
        p.add("authorization_endpoint");
        p.add("token_endpoint");
        p.add("userinfo_endpoint");
        p.add("registration_endpoint");
        p.add("check_session_iframe");
        p.add("end_session_endpoint");
        p.add("jwks_uri");
        p.add("scopes_supported");
        p.add("response_types_supported");
        p.add("response_modes_supported");
        p.add("grant_types_supported");
        p.add("code_challenge_methods_supported");
        p.add("acr_values_supported");
        p.add("subject_types_supported");
        p.add("token_endpoint_auth_methods_supported");
        p.add("token_endpoint_auth_signing_alg_values_supported");
        p.add("request_object_signing_alg_values_supported");
        p.add("request_object_encryption_alg_values_supported");
        p.add("request_object_encryption_enc_values_supported");
        p.add("id_token_signing_alg_values_supported");
        p.add("id_token_encryption_alg_values_supported");
        p.add("id_token_encryption_enc_values_supported");
        p.add("userinfo_signing_alg_values_supported");
        p.add("userinfo_encryption_alg_values_supported");
        p.add("userinfo_encryption_enc_values_supported");
        p.add("display_values_supported");
        p.add("claim_types_supported");
        p.add("claims_supported");
        p.add("claims_locales_supported");
        p.add("ui_locales_supported");
        p.add("service_documentation");
        p.add("op_policy_uri");
        p.add("op_tos_uri");
        p.add("claims_parameter_supported");
        p.add("request_parameter_supported");
        p.add("request_uri_parameter_supported");
        p.add("require_request_uri_registration");
        p.add("introspection_endpoint");
        p.add("revocation_endpoint");
        p.add("backchannel_logout_supported");
        p.add("backchannel_logout_session_supported");
        p.add("frontchannel_logout_supported");
        p.add("frontchannel_logout_session_supported");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(p);
    }

    public OIDCProviderMetadata(Issuer issuer, List<SubjectType> subjectTypes, URI jwkSetURI) {
        URI url;
        try {
            url = new URI(issuer.getValue());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The issuer identifier must be a URI: " + e.getMessage(), e);
        }
        if (url.getRawQuery() != null) {
            throw new IllegalArgumentException("The issuer URI must be without a query component");
        }
        if (url.getRawFragment() != null) {
            throw new IllegalArgumentException("The issuer URI must be without a fragment component ");
        }
        this.issuer = issuer;
        if (subjectTypes.size() < 1) {
            throw new IllegalArgumentException("At least one supported subject type must be specified");
        }
        this.subjectTypes = subjectTypes;
        if (jwkSetURI == null) {
            throw new IllegalArgumentException("The public JWK set URI must not be null");
        }
        this.jwkSetURI = jwkSetURI;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public URI getAuthorizationEndpointURI() {
        return this.authzEndpoint;
    }

    public void setAuthorizationEndpointURI(URI authzEndpoint) {
        this.authzEndpoint = authzEndpoint;
    }

    public URI getTokenEndpointURI() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpointURI(URI tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public URI getUserInfoEndpointURI() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpointURI(URI userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public URI getRegistrationEndpointURI() {
        return this.regEndpoint;
    }

    public void setRegistrationEndpointURI(URI regEndpoint) {
        this.regEndpoint = regEndpoint;
    }

    public URI getIntrospectionEndpointURI() {
        return this.introspectionEndpoint;
    }

    public void setIntrospectionEndpointURI(URI introspectionEndpoint) {
        this.introspectionEndpoint = introspectionEndpoint;
    }

    public URI getRevocationEndpointURI() {
        return this.revocationEndpoint;
    }

    public void setRevocationEndpointURI(URI revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
    }

    public URI getCheckSessionIframeURI() {
        return this.checkSessionIframe;
    }

    public void setCheckSessionIframeURI(URI checkSessionIframe) {
        this.checkSessionIframe = checkSessionIframe;
    }

    public URI getEndSessionEndpointURI() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpointURI(URI endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    public URI getJWKSetURI() {
        return this.jwkSetURI;
    }

    public Scope getScopes() {
        return this.scope;
    }

    public void setScopes(Scope scope) {
        this.scope = scope;
    }

    public List<ResponseType> getResponseTypes() {
        return this.rts;
    }

    public void setResponseTypes(List<ResponseType> rts) {
        this.rts = rts;
    }

    public List<ResponseMode> getResponseModes() {
        return this.rms;
    }

    public void setResponseModes(List<ResponseMode> rms) {
        this.rms = rms;
    }

    public List<GrantType> getGrantTypes() {
        return this.gts;
    }

    public void setGrantTypes(List<GrantType> gts) {
        this.gts = gts;
    }

    public List<CodeChallengeMethod> getCodeChallengeMethods() {
        return this.codeChallengeMethods;
    }

    public void setCodeChallengeMethods(List<CodeChallengeMethod> codeChallengeMethods) {
        this.codeChallengeMethods = codeChallengeMethods;
    }

    public List<ACR> getACRs() {
        return this.acrValues;
    }

    public void setACRs(List<ACR> acrValues) {
        this.acrValues = acrValues;
    }

    public List<SubjectType> getSubjectTypes() {
        return this.subjectTypes;
    }

    public List<ClientAuthenticationMethod> getTokenEndpointAuthMethods() {
        return this.tokenEndpointAuthMethods;
    }

    public void setTokenEndpointAuthMethods(List<ClientAuthenticationMethod> tokenEndpointAuthMethods) {
        this.tokenEndpointAuthMethods = tokenEndpointAuthMethods;
    }

    public List<JWSAlgorithm> getTokenEndpointJWSAlgs() {
        return this.tokenEndpointJWSAlgs;
    }

    public void setTokenEndpointJWSAlgs(List<JWSAlgorithm> tokenEndpointJWSAlgs) {
        if (tokenEndpointJWSAlgs != null && tokenEndpointJWSAlgs.contains(Algorithm.NONE)) {
            throw new IllegalArgumentException("The none algorithm is not accepted");
        }
        this.tokenEndpointJWSAlgs = tokenEndpointJWSAlgs;
    }

    public List<JWSAlgorithm> getRequestObjectJWSAlgs() {
        return this.requestObjectJWSAlgs;
    }

    public void setRequestObjectJWSAlgs(List<JWSAlgorithm> requestObjectJWSAlgs) {
        this.requestObjectJWSAlgs = requestObjectJWSAlgs;
    }

    public List<JWEAlgorithm> getRequestObjectJWEAlgs() {
        return this.requestObjectJWEAlgs;
    }

    public void setRequestObjectJWEAlgs(List<JWEAlgorithm> requestObjectJWEAlgs) {
        this.requestObjectJWEAlgs = requestObjectJWEAlgs;
    }

    public List<EncryptionMethod> getRequestObjectJWEEncs() {
        return this.requestObjectJWEEncs;
    }

    public void setRequestObjectJWEEncs(List<EncryptionMethod> requestObjectJWEEncs) {
        this.requestObjectJWEEncs = requestObjectJWEEncs;
    }

    public List<JWSAlgorithm> getIDTokenJWSAlgs() {
        return this.idTokenJWSAlgs;
    }

    public void setIDTokenJWSAlgs(List<JWSAlgorithm> idTokenJWSAlgs) {
        this.idTokenJWSAlgs = idTokenJWSAlgs;
    }

    public List<JWEAlgorithm> getIDTokenJWEAlgs() {
        return this.idTokenJWEAlgs;
    }

    public void setIDTokenJWEAlgs(List<JWEAlgorithm> idTokenJWEAlgs) {
        this.idTokenJWEAlgs = idTokenJWEAlgs;
    }

    public List<EncryptionMethod> getIDTokenJWEEncs() {
        return this.idTokenJWEEncs;
    }

    public void setIDTokenJWEEncs(List<EncryptionMethod> idTokenJWEEncs) {
        this.idTokenJWEEncs = idTokenJWEEncs;
    }

    public List<JWSAlgorithm> getUserInfoJWSAlgs() {
        return this.userInfoJWSAlgs;
    }

    public void setUserInfoJWSAlgs(List<JWSAlgorithm> userInfoJWSAlgs) {
        this.userInfoJWSAlgs = userInfoJWSAlgs;
    }

    public List<JWEAlgorithm> getUserInfoJWEAlgs() {
        return this.userInfoJWEAlgs;
    }

    public void setUserInfoJWEAlgs(List<JWEAlgorithm> userInfoJWEAlgs) {
        this.userInfoJWEAlgs = userInfoJWEAlgs;
    }

    public List<EncryptionMethod> getUserInfoJWEEncs() {
        return this.userInfoJWEEncs;
    }

    public void setUserInfoJWEEncs(List<EncryptionMethod> userInfoJWEEncs) {
        this.userInfoJWEEncs = userInfoJWEEncs;
    }

    public List<Display> getDisplays() {
        return this.displays;
    }

    public void setDisplays(List<Display> displays) {
        this.displays = displays;
    }

    public List<ClaimType> getClaimTypes() {
        return this.claimTypes;
    }

    public void setClaimTypes(List<ClaimType> claimTypes) {
        this.claimTypes = claimTypes;
    }

    public List<String> getClaims() {
        return this.claims;
    }

    public void setClaims(List<String> claims) {
        this.claims = claims;
    }

    public List<LangTag> getClaimsLocales() {
        return this.claimsLocales;
    }

    public void setClaimLocales(List<LangTag> claimsLocales) {
        this.claimsLocales = claimsLocales;
    }

    public List<LangTag> getUILocales() {
        return this.uiLocales;
    }

    public void setUILocales(List<LangTag> uiLocales) {
        this.uiLocales = uiLocales;
    }

    public URI getServiceDocsURI() {
        return this.serviceDocsURI;
    }

    public void setServiceDocsURI(URI serviceDocsURI) {
        this.serviceDocsURI = serviceDocsURI;
    }

    public URI getPolicyURI() {
        return this.policyURI;
    }

    public void setPolicyURI(URI policyURI) {
        this.policyURI = policyURI;
    }

    public URI getTermsOfServiceURI() {
        return this.tosURI;
    }

    public void setTermsOfServiceURI(URI tosURI) {
        this.tosURI = tosURI;
    }

    public boolean supportsClaimsParam() {
        return this.claimsParamSupported;
    }

    public void setSupportsClaimsParams(boolean claimsParamSupported) {
        this.claimsParamSupported = claimsParamSupported;
    }

    public boolean supportsRequestParam() {
        return this.requestParamSupported;
    }

    public void setSupportsRequestParam(boolean requestParamSupported) {
        this.requestParamSupported = requestParamSupported;
    }

    public boolean supportsRequestURIParam() {
        return this.requestURIParamSupported;
    }

    public void setSupportsRequestURIParam(boolean requestURIParamSupported) {
        this.requestURIParamSupported = requestURIParamSupported;
    }

    public boolean requiresRequestURIRegistration() {
        return this.requireRequestURIReg;
    }

    public void setRequiresRequestURIRegistration(boolean requireRequestURIReg) {
        this.requireRequestURIReg = requireRequestURIReg;
    }

    public boolean supportsFrontChannelLogout() {
        return this.frontChannelLogoutSupported;
    }

    public void setSupportsFrontChannelLogout(boolean frontChannelLogoutSupported) {
        this.frontChannelLogoutSupported = frontChannelLogoutSupported;
    }

    public boolean supportsFrontChannelLogoutSession() {
        return this.frontChannelLogoutSessionSupported;
    }

    public void setSupportsFrontChannelLogoutSession(boolean frontChannelLogoutSessionSupported) {
        this.frontChannelLogoutSessionSupported = frontChannelLogoutSessionSupported;
    }

    public boolean supportsBackChannelLogout() {
        return this.backChannelLogoutSupported;
    }

    public void setSupportsBackChannelLogout(boolean backChannelLogoutSupported) {
        this.backChannelLogoutSupported = backChannelLogoutSupported;
    }

    public boolean supportsBackChannelLogoutSession() {
        return this.backChannelLogoutSessionSupported;
    }

    public void setSupportsBackChannelLogoutSession(boolean backChannelLogoutSessionSupported) {
        this.backChannelLogoutSessionSupported = backChannelLogoutSessionSupported;
    }

    public Object getCustomParameter(String name) {
        return this.customParameters.get((Object)name);
    }

    public URI getCustomURIParameter(String name) {
        try {
            return JSONObjectUtils.getURI(this.customParameters, name);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setCustomParameter(String name, Object value) {
        if (REGISTERED_PARAMETER_NAMES.contains(name)) {
            throw new IllegalArgumentException("The " + name + " parameter is registered");
        }
        this.customParameters.put((Object)name, value);
    }

    public JSONObject getCustomParameters() {
        return this.customParameters;
    }

    public void applyDefaults() {
        if (this.rms == null) {
            this.rms = new ArrayList<ResponseMode>(2);
            this.rms.add(ResponseMode.QUERY);
            this.rms.add(ResponseMode.FRAGMENT);
        }
        if (this.gts == null) {
            this.gts = new ArrayList<GrantType>(2);
            this.gts.add(GrantType.AUTHORIZATION_CODE);
            this.gts.add(GrantType.IMPLICIT);
        }
        if (this.claimTypes == null) {
            this.claimTypes = new ArrayList<ClaimType>(1);
            this.claimTypes.add(ClaimType.NORMAL);
        }
    }

    public JSONObject toJSONObject() {
        OrderedJSONObject o = new OrderedJSONObject();
        o.put("issuer", this.issuer.getValue());
        ArrayList<String> stringList = new ArrayList<String>(this.subjectTypes.size());
        for (SubjectType subjectType : this.subjectTypes) {
            stringList.add(subjectType.toString());
        }
        o.put("subject_types_supported", stringList);
        o.put("jwks_uri", this.jwkSetURI.toString());
        if (this.authzEndpoint != null) {
            o.put("authorization_endpoint", this.authzEndpoint.toString());
        }
        if (this.tokenEndpoint != null) {
            o.put("token_endpoint", this.tokenEndpoint.toString());
        }
        if (this.userInfoEndpoint != null) {
            o.put("userinfo_endpoint", this.userInfoEndpoint.toString());
        }
        if (this.regEndpoint != null) {
            o.put("registration_endpoint", this.regEndpoint.toString());
        }
        if (this.introspectionEndpoint != null) {
            o.put("introspection_endpoint", this.introspectionEndpoint.toString());
        }
        if (this.revocationEndpoint != null) {
            o.put("revocation_endpoint", this.revocationEndpoint.toString());
        }
        if (this.checkSessionIframe != null) {
            o.put("check_session_iframe", this.checkSessionIframe.toString());
        }
        if (this.endSessionEndpoint != null) {
            o.put("end_session_endpoint", this.endSessionEndpoint.toString());
        }
        if (this.scope != null) {
            o.put("scopes_supported", this.scope.toStringList());
        }
        if (this.rts != null) {
            stringList = new ArrayList(this.rts.size());
            for (ResponseType responseType : this.rts) {
                stringList.add(responseType.toString());
            }
            o.put("response_types_supported", stringList);
        }
        if (this.rms != null) {
            stringList = new ArrayList(this.rms.size());
            for (ResponseMode responseMode : this.rms) {
                stringList.add(responseMode.getValue());
            }
            o.put("response_modes_supported", stringList);
        }
        if (this.gts != null) {
            stringList = new ArrayList(this.gts.size());
            for (GrantType grantType : this.gts) {
                stringList.add(grantType.toString());
            }
            o.put("grant_types_supported", stringList);
        }
        if (this.codeChallengeMethods != null) {
            stringList = new ArrayList(this.codeChallengeMethods.size());
            for (CodeChallengeMethod codeChallengeMethod : this.codeChallengeMethods) {
                stringList.add(codeChallengeMethod.getValue());
            }
            o.put("code_challenge_methods_supported", stringList);
        }
        if (this.acrValues != null) {
            stringList = new ArrayList(this.acrValues.size());
            for (ACR aCR : this.acrValues) {
                stringList.add(aCR.getValue());
            }
            o.put("acr_values_supported", stringList);
        }
        if (this.tokenEndpointAuthMethods != null) {
            stringList = new ArrayList(this.tokenEndpointAuthMethods.size());
            for (ClientAuthenticationMethod clientAuthenticationMethod : this.tokenEndpointAuthMethods) {
                stringList.add(clientAuthenticationMethod.getValue());
            }
            o.put("token_endpoint_auth_methods_supported", stringList);
        }
        if (this.tokenEndpointJWSAlgs != null) {
            stringList = new ArrayList(this.tokenEndpointJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.tokenEndpointJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put("token_endpoint_auth_signing_alg_values_supported", stringList);
        }
        if (this.requestObjectJWSAlgs != null) {
            stringList = new ArrayList(this.requestObjectJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.requestObjectJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put("request_object_signing_alg_values_supported", stringList);
        }
        if (this.requestObjectJWEAlgs != null) {
            stringList = new ArrayList(this.requestObjectJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.requestObjectJWEAlgs) {
                stringList.add(jWEAlgorithm.getName());
            }
            o.put("request_object_encryption_alg_values_supported", stringList);
        }
        if (this.requestObjectJWEEncs != null) {
            stringList = new ArrayList(this.requestObjectJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.requestObjectJWEEncs) {
                stringList.add(encryptionMethod.getName());
            }
            o.put("request_object_encryption_enc_values_supported", stringList);
        }
        if (this.idTokenJWSAlgs != null) {
            stringList = new ArrayList(this.idTokenJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.idTokenJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put("id_token_signing_alg_values_supported", stringList);
        }
        if (this.idTokenJWEAlgs != null) {
            stringList = new ArrayList(this.idTokenJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.idTokenJWEAlgs) {
                stringList.add(jWEAlgorithm.getName());
            }
            o.put("id_token_encryption_alg_values_supported", stringList);
        }
        if (this.idTokenJWEEncs != null) {
            stringList = new ArrayList(this.idTokenJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.idTokenJWEEncs) {
                stringList.add(encryptionMethod.getName());
            }
            o.put("id_token_encryption_enc_values_supported", stringList);
        }
        if (this.userInfoJWSAlgs != null) {
            stringList = new ArrayList(this.userInfoJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.userInfoJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put("userinfo_signing_alg_values_supported", stringList);
        }
        if (this.userInfoJWEAlgs != null) {
            stringList = new ArrayList(this.userInfoJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.userInfoJWEAlgs) {
                stringList.add(jWEAlgorithm.getName());
            }
            o.put("userinfo_encryption_alg_values_supported", stringList);
        }
        if (this.userInfoJWEEncs != null) {
            stringList = new ArrayList(this.userInfoJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.userInfoJWEEncs) {
                stringList.add(encryptionMethod.getName());
            }
            o.put("userinfo_encryption_enc_values_supported", stringList);
        }
        if (this.displays != null) {
            stringList = new ArrayList(this.displays.size());
            for (Display display : this.displays) {
                stringList.add(display.toString());
            }
            o.put("display_values_supported", stringList);
        }
        if (this.claimTypes != null) {
            stringList = new ArrayList(this.claimTypes.size());
            for (ClaimType claimType : this.claimTypes) {
                stringList.add(claimType.toString());
            }
            o.put("claim_types_supported", stringList);
        }
        if (this.claims != null) {
            o.put("claims_supported", this.claims);
        }
        if (this.claimsLocales != null) {
            stringList = new ArrayList(this.claimsLocales.size());
            for (LangTag langTag : this.claimsLocales) {
                stringList.add(langTag.toString());
            }
            o.put("claims_locales_supported", stringList);
        }
        if (this.uiLocales != null) {
            stringList = new ArrayList(this.uiLocales.size());
            for (LangTag langTag : this.uiLocales) {
                stringList.add(langTag.toString());
            }
            o.put("ui_locales_supported", stringList);
        }
        if (this.serviceDocsURI != null) {
            o.put("service_documentation", this.serviceDocsURI.toString());
        }
        if (this.policyURI != null) {
            o.put("op_policy_uri", this.policyURI.toString());
        }
        if (this.tosURI != null) {
            o.put("op_tos_uri", this.tosURI.toString());
        }
        o.put("claims_parameter_supported", this.claimsParamSupported);
        o.put("request_parameter_supported", this.requestParamSupported);
        o.put("request_uri_parameter_supported", this.requestURIParamSupported);
        o.put("require_request_uri_registration", this.requireRequestURIReg);
        o.put("frontchannel_logout_supported", this.frontChannelLogoutSupported);
        if (this.frontChannelLogoutSupported) {
            o.put("frontchannel_logout_session_supported", this.frontChannelLogoutSessionSupported);
        }
        o.put("backchannel_logout_supported", this.backChannelLogoutSupported);
        if (this.backChannelLogoutSupported) {
            o.put("backchannel_logout_session_supported", this.backChannelLogoutSessionSupported);
        }
        o.putAll((Map)this.customParameters);
        return o;
    }

    public static OIDCProviderMetadata parse(JSONObject jsonObject) throws ParseException {
        String v;
        int n;
        int n2;
        String[] stringArray;
        ArrayList<SubjectType> subjectTypes = new ArrayList<SubjectType>();
        String[] stringArray2 = JSONObjectUtils.getStringArray(jsonObject, "subject_types_supported");
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            String v2 = stringArray2[n4];
            subjectTypes.add(SubjectType.parse(v2));
            ++n4;
        }
        Issuer issuer = new Issuer(JSONObjectUtils.getURI(jsonObject, "issuer").toString());
        URI jwkSetURI = JSONObjectUtils.getURI(jsonObject, "jwks_uri");
        OIDCProviderMetadata op = new OIDCProviderMetadata(issuer, Collections.unmodifiableList(subjectTypes), jwkSetURI);
        if (jsonObject.get((Object)"authorization_endpoint") != null) {
            op.authzEndpoint = JSONObjectUtils.getURI(jsonObject, "authorization_endpoint");
        }
        if (jsonObject.get((Object)"token_endpoint") != null) {
            op.tokenEndpoint = JSONObjectUtils.getURI(jsonObject, "token_endpoint");
        }
        if (jsonObject.get((Object)"userinfo_endpoint") != null) {
            op.userInfoEndpoint = JSONObjectUtils.getURI(jsonObject, "userinfo_endpoint");
        }
        if (jsonObject.get((Object)"registration_endpoint") != null) {
            op.regEndpoint = JSONObjectUtils.getURI(jsonObject, "registration_endpoint");
        }
        if (jsonObject.get((Object)"introspection_endpoint") != null) {
            op.introspectionEndpoint = JSONObjectUtils.getURI(jsonObject, "introspection_endpoint");
        }
        if (jsonObject.get((Object)"revocation_endpoint") != null) {
            op.revocationEndpoint = JSONObjectUtils.getURI(jsonObject, "revocation_endpoint");
        }
        if (jsonObject.get((Object)"check_session_iframe") != null) {
            op.checkSessionIframe = JSONObjectUtils.getURI(jsonObject, "check_session_iframe");
        }
        if (jsonObject.get((Object)"end_session_endpoint") != null) {
            op.endSessionEndpoint = JSONObjectUtils.getURI(jsonObject, "end_session_endpoint");
        }
        if (jsonObject.get((Object)"scopes_supported") != null) {
            op.scope = new Scope();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "scopes_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.scope.add(new Scope.Value(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"response_types_supported") != null) {
            op.rts = new ArrayList<ResponseType>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "response_types_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.rts.add(ResponseType.parse(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"response_modes_supported") != null) {
            op.rms = new ArrayList<ResponseMode>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "response_modes_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.rms.add(new ResponseMode(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"grant_types_supported") != null) {
            op.gts = new ArrayList<GrantType>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "grant_types_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.gts.add(GrantType.parse(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"code_challenge_methods_supported") != null) {
            op.codeChallengeMethods = new ArrayList<CodeChallengeMethod>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "code_challenge_methods_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.codeChallengeMethods.add(CodeChallengeMethod.parse(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"acr_values_supported") != null) {
            op.acrValues = new ArrayList<ACR>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "acr_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.acrValues.add(new ACR(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"token_endpoint_auth_methods_supported") != null) {
            op.tokenEndpointAuthMethods = new ArrayList<ClientAuthenticationMethod>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "token_endpoint_auth_methods_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.tokenEndpointAuthMethods.add(ClientAuthenticationMethod.parse(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"token_endpoint_auth_signing_alg_values_supported") != null) {
            op.tokenEndpointJWSAlgs = new ArrayList<JWSAlgorithm>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "token_endpoint_auth_signing_alg_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null && v.equals(Algorithm.NONE.getName())) {
                    throw new ParseException("The none algorithm is not accepted");
                }
                if (v != null) {
                    op.tokenEndpointJWSAlgs.add(JWSAlgorithm.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"request_object_signing_alg_values_supported") != null) {
            op.requestObjectJWSAlgs = new ArrayList<JWSAlgorithm>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "request_object_signing_alg_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.requestObjectJWSAlgs.add(JWSAlgorithm.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"request_object_encryption_alg_values_supported") != null) {
            op.requestObjectJWEAlgs = new ArrayList<JWEAlgorithm>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "request_object_encryption_alg_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.requestObjectJWEAlgs.add(JWEAlgorithm.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"request_object_encryption_enc_values_supported") != null) {
            op.requestObjectJWEEncs = new ArrayList<EncryptionMethod>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "request_object_encryption_enc_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.requestObjectJWEEncs.add(EncryptionMethod.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"id_token_signing_alg_values_supported") != null) {
            op.idTokenJWSAlgs = new ArrayList<JWSAlgorithm>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "id_token_signing_alg_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.idTokenJWSAlgs.add(JWSAlgorithm.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"id_token_encryption_alg_values_supported") != null) {
            op.idTokenJWEAlgs = new ArrayList<JWEAlgorithm>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "id_token_encryption_alg_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.idTokenJWEAlgs.add(JWEAlgorithm.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"id_token_encryption_enc_values_supported") != null) {
            op.idTokenJWEEncs = new ArrayList<EncryptionMethod>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "id_token_encryption_enc_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.idTokenJWEEncs.add(EncryptionMethod.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"userinfo_signing_alg_values_supported") != null) {
            op.userInfoJWSAlgs = new ArrayList<JWSAlgorithm>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "userinfo_signing_alg_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.userInfoJWSAlgs.add(JWSAlgorithm.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"userinfo_encryption_alg_values_supported") != null) {
            op.userInfoJWEAlgs = new ArrayList<JWEAlgorithm>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "userinfo_encryption_alg_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.userInfoJWEAlgs.add(JWEAlgorithm.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"userinfo_encryption_enc_values_supported") != null) {
            op.userInfoJWEEncs = new ArrayList<EncryptionMethod>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "userinfo_encryption_enc_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.userInfoJWEEncs.add(EncryptionMethod.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"display_values_supported") != null) {
            op.displays = new ArrayList<Display>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "display_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.displays.add(Display.parse(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"claim_types_supported") != null) {
            op.claimTypes = new ArrayList<ClaimType>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "claim_types_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.claimTypes.add(ClaimType.parse(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"claims_supported") != null) {
            op.claims = new ArrayList<String>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "claims_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    op.claims.add(v);
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"claims_locales_supported") != null) {
            op.claimsLocales = new ArrayList<LangTag>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "claims_locales_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    try {
                        op.claimsLocales.add(LangTag.parse((String)v));
                    }
                    catch (LangTagException e) {
                        throw new ParseException("Invalid claims_locales_supported field: " + e.getMessage(), e);
                    }
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"ui_locales_supported") != null) {
            op.uiLocales = new ArrayList<LangTag>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "ui_locales_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    try {
                        op.uiLocales.add(LangTag.parse((String)v));
                    }
                    catch (LangTagException e) {
                        throw new ParseException("Invalid ui_locales_supported field: " + e.getMessage(), e);
                    }
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"service_documentation") != null) {
            op.serviceDocsURI = JSONObjectUtils.getURI(jsonObject, "service_documentation");
        }
        if (jsonObject.get((Object)"op_policy_uri") != null) {
            op.policyURI = JSONObjectUtils.getURI(jsonObject, "op_policy_uri");
        }
        if (jsonObject.get((Object)"op_tos_uri") != null) {
            op.tosURI = JSONObjectUtils.getURI(jsonObject, "op_tos_uri");
        }
        if (jsonObject.get((Object)"claims_parameter_supported") != null) {
            op.claimsParamSupported = JSONObjectUtils.getBoolean(jsonObject, "claims_parameter_supported");
        }
        if (jsonObject.get((Object)"request_parameter_supported") != null) {
            op.requestParamSupported = JSONObjectUtils.getBoolean(jsonObject, "request_parameter_supported");
        }
        if (jsonObject.get((Object)"request_uri_parameter_supported") != null) {
            op.requestURIParamSupported = JSONObjectUtils.getBoolean(jsonObject, "request_uri_parameter_supported");
        }
        if (jsonObject.get((Object)"require_request_uri_registration") != null) {
            op.requireRequestURIReg = JSONObjectUtils.getBoolean(jsonObject, "require_request_uri_registration");
        }
        if (jsonObject.get((Object)"frontchannel_logout_supported") != null) {
            op.frontChannelLogoutSupported = JSONObjectUtils.getBoolean(jsonObject, "frontchannel_logout_supported");
        }
        if (op.frontChannelLogoutSupported && jsonObject.get((Object)"frontchannel_logout_session_supported") != null) {
            op.frontChannelLogoutSessionSupported = JSONObjectUtils.getBoolean(jsonObject, "frontchannel_logout_session_supported");
        }
        if (jsonObject.get((Object)"backchannel_logout_supported") != null) {
            op.backChannelLogoutSupported = JSONObjectUtils.getBoolean(jsonObject, "backchannel_logout_supported");
        }
        if (op.frontChannelLogoutSupported && jsonObject.get((Object)"backchannel_logout_session_supported") != null) {
            op.backChannelLogoutSessionSupported = JSONObjectUtils.getBoolean(jsonObject, "backchannel_logout_session_supported");
        }
        JSONObject customParams = new JSONObject((Map)jsonObject);
        customParams.keySet().removeAll(REGISTERED_PARAMETER_NAMES);
        for (Map.Entry customEntry : customParams.entrySet()) {
            op.setCustomParameter((String)customEntry.getKey(), customEntry.getValue());
        }
        return op;
    }

    public static OIDCProviderMetadata parse(String s) throws ParseException {
        return OIDCProviderMetadata.parse(JSONObjectUtils.parse(s));
    }

    public static OIDCProviderMetadata resolve(Issuer issuer) throws GeneralException, IOException {
        return OIDCProviderMetadata.resolve(issuer, 0, 0);
    }

    public static OIDCProviderMetadata resolve(Issuer issuer, int connectTimeout, int readTimeout) throws GeneralException, IOException {
        URL configURL;
        try {
            URL issuerURL = new URL(issuer.getValue());
            if (issuerURL.getQuery() != null && !issuerURL.getQuery().trim().isEmpty()) {
                throw new GeneralException("The issuer identifier must not contain a query component");
            }
            configURL = issuerURL.getPath() != null && issuerURL.getPath().endsWith("/") ? new URL(issuerURL + ".well-known/openid-configuration") : new URL(issuerURL + "/.well-known/openid-configuration");
        }
        catch (MalformedURLException e) {
            throw new GeneralException("The issuer identifier doesn't represent a valid URL: " + e.getMessage(), e);
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.GET, configURL);
        httpRequest.setConnectTimeout(connectTimeout);
        httpRequest.setReadTimeout(readTimeout);
        HTTPResponse httpResponse = httpRequest.send();
        if (httpResponse.getStatusCode() != 200) {
            throw new IOException("Couldn't download OpenID Provider metadata from " + configURL + ": Status code " + httpResponse.getStatusCode());
        }
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        return OIDCProviderMetadata.parse(jsonObject);
    }
}

