/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.SharePathError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class ShareFolderError {
    public static final ShareFolderError EMAIL_UNVERIFIED = new ShareFolderError(Tag.EMAIL_UNVERIFIED, null);
    public static final ShareFolderError TEAM_POLICY_DISALLOWS_MEMBER_POLICY = new ShareFolderError(Tag.TEAM_POLICY_DISALLOWS_MEMBER_POLICY, null);
    public static final ShareFolderError DISALLOWED_SHARED_LINK_POLICY = new ShareFolderError(Tag.DISALLOWED_SHARED_LINK_POLICY, null);
    public static final ShareFolderError OTHER = new ShareFolderError(Tag.OTHER, null);
    public static final ShareFolderError NO_PERMISSION = new ShareFolderError(Tag.NO_PERMISSION, null);
    private final Tag _tag;
    private final SharePathError badPathValue;

    private ShareFolderError(Tag _tag, SharePathError badPathValue) {
        this._tag = _tag;
        this.badPathValue = badPathValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isEmailUnverified() {
        return this._tag == Tag.EMAIL_UNVERIFIED;
    }

    public boolean isBadPath() {
        return this._tag == Tag.BAD_PATH;
    }

    public static ShareFolderError badPath(SharePathError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ShareFolderError(Tag.BAD_PATH, value);
    }

    public SharePathError getBadPathValue() {
        if (this._tag != Tag.BAD_PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.BAD_PATH, but was Tag." + this._tag.name());
        }
        return this.badPathValue;
    }

    public boolean isTeamPolicyDisallowsMemberPolicy() {
        return this._tag == Tag.TEAM_POLICY_DISALLOWS_MEMBER_POLICY;
    }

    public boolean isDisallowedSharedLinkPolicy() {
        return this._tag == Tag.DISALLOWED_SHARED_LINK_POLICY;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isNoPermission() {
        return this._tag == Tag.NO_PERMISSION;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.badPathValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ShareFolderError) {
            ShareFolderError other = (ShareFolderError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case EMAIL_UNVERIFIED: {
                    return true;
                }
                case BAD_PATH: {
                    return this.badPathValue == other.badPathValue || this.badPathValue.equals(other.badPathValue);
                }
                case TEAM_POLICY_DISALLOWS_MEMBER_POLICY: {
                    return true;
                }
                case DISALLOWED_SHARED_LINK_POLICY: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
                case NO_PERMISSION: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<ShareFolderError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ShareFolderError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case EMAIL_UNVERIFIED: {
                    g.writeString("email_unverified");
                    break;
                }
                case BAD_PATH: {
                    g.writeStartObject();
                    this.writeTag("bad_path", g);
                    g.writeFieldName("bad_path");
                    SharePathError.Serializer.INSTANCE.serialize(value.badPathValue, g);
                    g.writeEndObject();
                    break;
                }
                case TEAM_POLICY_DISALLOWS_MEMBER_POLICY: {
                    g.writeString("team_policy_disallows_member_policy");
                    break;
                }
                case DISALLOWED_SHARED_LINK_POLICY: {
                    g.writeString("disallowed_shared_link_policy");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case NO_PERMISSION: {
                    g.writeString("no_permission");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public ShareFolderError deserialize(JsonParser p) throws IOException, JsonParseException {
            ShareFolderError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("email_unverified".equals(tag)) {
                value = EMAIL_UNVERIFIED;
            } else if ("bad_path".equals(tag)) {
                SharePathError fieldValue = null;
                Serializer.expectField("bad_path", p);
                fieldValue = SharePathError.Serializer.INSTANCE.deserialize(p);
                value = ShareFolderError.badPath(fieldValue);
            } else if ("team_policy_disallows_member_policy".equals(tag)) {
                value = TEAM_POLICY_DISALLOWS_MEMBER_POLICY;
            } else if ("disallowed_shared_link_policy".equals(tag)) {
                value = DISALLOWED_SHARED_LINK_POLICY;
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("no_permission".equals(tag)) {
                value = NO_PERMISSION;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        EMAIL_UNVERIFIED,
        BAD_PATH,
        TEAM_POLICY_DISALLOWS_MEMBER_POLICY,
        DISALLOWED_SHARED_LINK_POLICY,
        OTHER,
        NO_PERMISSION;

    }
}

