/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.PropertyGroupUpdate;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

class UpdatePropertyGroupArg {
    protected final String path;
    protected final List<PropertyGroupUpdate> updatePropertyGroups;

    public UpdatePropertyGroupArg(String path, List<PropertyGroupUpdate> updatePropertyGroups) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("/(.|[\\r\\n])*|id:.*|(ns:[0-9]+(/.*)?)", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (updatePropertyGroups == null) {
            throw new IllegalArgumentException("Required value for 'updatePropertyGroups' is null");
        }
        for (PropertyGroupUpdate x : updatePropertyGroups) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'updatePropertyGroups' is null");
        }
        this.updatePropertyGroups = updatePropertyGroups;
    }

    public String getPath() {
        return this.path;
    }

    public List<PropertyGroupUpdate> getUpdatePropertyGroups() {
        return this.updatePropertyGroups;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.updatePropertyGroups});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            UpdatePropertyGroupArg other = (UpdatePropertyGroupArg)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.updatePropertyGroups != other.updatePropertyGroups && !this.updatePropertyGroups.equals(other.updatePropertyGroups));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UpdatePropertyGroupArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UpdatePropertyGroupArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("update_property_groups");
            StoneSerializers.list(PropertyGroupUpdate.Serializer.INSTANCE).serialize(value.updatePropertyGroups, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UpdatePropertyGroupArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<PropertyGroupUpdate> f_updatePropertyGroups;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_updatePropertyGroups = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("update_property_groups".equals(field)) {
                        f_updatePropertyGroups = StoneSerializers.list(PropertyGroupUpdate.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
                if (f_updatePropertyGroups == null) {
                    throw new JsonParseException(p, "Required field \"update_property_groups\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UpdatePropertyGroupArg value = new UpdatePropertyGroupArg(f_path, f_updatePropertyGroups);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

