/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.osgi.data.AbstractModule;
import com.openexchange.osgi.data.BinDirModule;
import com.openexchange.osgi.data.Classpath;
import com.openexchange.osgi.data.DirModule;
import com.openexchange.osgi.data.JarModule;
import com.openexchange.osgi.data.SrcDirModule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;

public class Tools {
    private Tools() {
    }

    public static Map<String, AbstractModule> calculateModulesByName(List<AbstractModule> allModules) {
        HashMap<String, AbstractModule> modulesByName = new HashMap<String, AbstractModule>();
        for (AbstractModule module : allModules) {
            modulesByName.put(module.getName(), module);
        }
        return modulesByName;
    }

    public static Map<String, Set<AbstractModule>> calculateModulesByPackage(List<AbstractModule> allModules) {
        HashMap<String, Set<AbstractModule>> modulesByPackage = new HashMap<String, Set<AbstractModule>>();
        for (AbstractModule module : allModules) {
            for (String exportedPackage : module.getExportedPackages()) {
                HashSet<AbstractModule> exportingModules = (HashSet<AbstractModule>)modulesByPackage.get(exportedPackage);
                if (exportingModules == null) {
                    exportingModules = new HashSet<AbstractModule>();
                    modulesByPackage.put(exportedPackage, exportingModules);
                }
                exportingModules.add(module);
            }
        }
        return modulesByPackage;
    }

    public static Map<String, AbstractModule> calculateModulesByFilename(List<AbstractModule> allModules) {
        HashMap<String, AbstractModule> modulesByFilename = new HashMap<String, AbstractModule>();
        for (AbstractModule module : allModules) {
            modulesByFilename.put(module.getFile().getName(), module);
        }
        return modulesByFilename;
    }

    public static DirModule readModule(List<AbstractModule> classpathModules, File bundleDirectory) throws IOException {
        File[] files;
        SrcDirModule module = new SrcDirModule(bundleDirectory);
        ((DirModule)module).readLocalFiles();
        File jarsDir = new File(bundleDirectory, "jars");
        if (jarsDir.exists() && jarsDir.isDirectory() && null != (files = jarsDir.listFiles())) {
            for (File osgiJar : files) {
                if (!osgiJar.isFile() || !osgiJar.getName().endsWith(".jar") || osgiJar.getName().startsWith(bundleDirectory.getName())) continue;
                classpathModules.add(new JarModule(osgiJar));
            }
        }
        return module;
    }

    public static List<AbstractModule> readClasspathModules(String[] files) throws IOException {
        ArrayList<AbstractModule> retval = new ArrayList<AbstractModule>(files.length);
        for (String classpathFilename : files) {
            File classpathFile = new File(classpathFilename);
            if (classpathFile.isFile()) {
                retval.add(new JarModule(classpathFile));
                continue;
            }
            if (classpathFile.isDirectory()) {
                BinDirModule classpathModule = new BinDirModule(classpathFile);
                ((DirModule)classpathModule).readLocalFiles();
                retval.add(classpathModule);
                continue;
            }
            throw new IOException("Don't know how to handle " + classpathFile.getAbsolutePath());
        }
        return retval;
    }

    public static Classpath getClasspath(Project project) {
        File classPath = new File(project.getProjectDir(), ".classpath");
        if (classPath.exists() && classPath.isFile()) {
            return new Classpath(classPath);
        }
        return null;
    }
}

