/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.examples;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.http.HttpClient;
import twitter4j.http.Response;

public class FeedMonitor {
    static Logger log = LoggerFactory.getLogger(FeedMonitor.class);
    private Properties prop = new Properties();
    private String feedurl;
    private Twitter twitter;
    private HttpClient http = new HttpClient();
    private Date lastUpdate;
    private String fileName;

    public static void main(String[] args) {
        int interval = 10;
        ArrayList<FeedMonitor> list = new ArrayList<FeedMonitor>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            try {
                interval = Integer.parseInt(arg);
            }
            catch (NumberFormatException nfe) {
                list.add(new FeedMonitor(arg));
            }
            ++n2;
        }
        if (list.size() == 0) {
            list.add(new FeedMonitor("feedmonitor.properties"));
        }
        while (true) {
            for (FeedMonitor monitor : list) {
                monitor.check();
            }
            try {
                log.info("Sleeping " + interval + " minutes.");
                Thread.sleep(interval * 60 * 1000);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public FeedMonitor(String fileName) {
        this.fileName = fileName;
        log.info("Loading properties from " + fileName);
        try {
            this.prop.load(new FileInputStream(fileName));
        }
        catch (IOException ex) {
            log.error("Configuration file not found:" + ex.getMessage());
            System.exit(-1);
        }
        this.twitter = new Twitter(this.prop.getProperty("id"), this.prop.getProperty("password"));
        this.feedurl = this.prop.getProperty("feedurl");
        this.lastUpdate = new Date(Long.valueOf(this.prop.getProperty("lastUpdate", "0")));
    }

    private void check() {
        log.info("Checking feed from {}", (Object)this.feedurl);
        Date latestEntry = this.lastUpdate;
        log.info("Last update is {}", (Object)this.lastUpdate);
        try {
            Response res = this.http.get(this.feedurl);
            List entries = new SyndFeedInput().build(res.asDocument()).getEntries();
            Collections.sort(entries, new Comparator<SyndEntry>(){

                @Override
                public int compare(SyndEntry o1, SyndEntry o2) {
                    return o1.getPublishedDate().compareTo(o2.getPublishedDate());
                }
            });
            for (SyndEntry entry : entries) {
                if (!this.lastUpdate.before(entry.getPublishedDate())) continue;
                latestEntry = latestEntry.before(entry.getPublishedDate()) ? entry.getPublishedDate() : latestEntry;
                String title = entry.getTitle().split("\n")[0];
                String link = entry.getLink();
                log.info("New entry \"{}\" published at {}", (Object)title, (Object)entry.getPublishedDate());
                String status = String.valueOf(title) + " " + link;
                if (status.length() > 160) {
                    if (link.length() > 160) {
                        int cutLength = status.length() - 159;
                        status = String.valueOf(title.substring(0, title.length() - cutLength)) + " " + link;
                    } else {
                        status = title.length() > 160 ? title.substring(0, 160) : title;
                    }
                }
                log.info("Updating Twitter.");
                this.twitter.updateStatus(status);
                log.info("Done.");
            }
            if (!this.lastUpdate.equals(latestEntry)) {
                log.info("Updating last update.");
                this.prop.setProperty("lastUpdate", String.valueOf(latestEntry.getTime()));
                try {
                    this.prop.store(new FileOutputStream(this.fileName), "FeedMonitor");
                }
                catch (IOException ex1) {
                    log.error("Failed to save configuration file:" + ex1.getMessage());
                }
            } else {
                log.info("No new entry found.");
            }
        }
        catch (TwitterException te) {
            log.info("Failed to fetch the feed:" + te.getMessage());
        }
        catch (FeedException fe) {
            log.info("Failed to parse the feed:" + fe.getMessage());
        }
    }
}

