/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.DistroNaming;
import com.openexchange.obs.api.ProjectReference;
import com.openexchange.obs.api.RepositoryReference;

public final class Path {
    private final ProjectReference project;
    private final RepositoryReference repository;

    public Path(ProjectReference project, RepositoryReference repository) {
        this.project = project;
        this.repository = repository;
    }

    public static Path standard(DistroNaming distro) throws BuildServiceException {
        return new Path(ProjectReference.byName(distro), RepositoryReference.STANDARD);
    }

    public RepositoryReference getRepository() {
        return this.repository;
    }

    public ProjectReference getProject() {
        return this.project;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Path)) {
            return false;
        }
        Path other = (Path)obj;
        if (this.project == null ? other.project != null : !this.project.equals(other.project)) {
            return false;
        }
        return !(this.repository == null ? other.repository != null : !this.repository.equals(other.repository));
    }

    public String toString() {
        return "Path: ( project " + this.project.getName() + " repository " + this.repository.getName() + " )";
    }
}

