/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.AsfExtHeaderReader;
import org.jaudiotagger.audio.asf.io.ChunkContainerReader;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.io.ContentBrandingReader;
import org.jaudiotagger.audio.asf.io.ContentDescriptionReader;
import org.jaudiotagger.audio.asf.io.EncodingChunkReader;
import org.jaudiotagger.audio.asf.io.EncryptionChunkReader;
import org.jaudiotagger.audio.asf.io.FileHeaderReader;
import org.jaudiotagger.audio.asf.io.FullRequestInputStream;
import org.jaudiotagger.audio.asf.io.LanguageListReader;
import org.jaudiotagger.audio.asf.io.MetadataReader;
import org.jaudiotagger.audio.asf.io.RandomAccessFileInputstream;
import org.jaudiotagger.audio.asf.io.StreamBitratePropertiesReader;
import org.jaudiotagger.audio.asf.io.StreamChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsfHeaderReader
extends ChunkContainerReader<AsfHeader> {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_HEADER};
    private static final AsfHeaderReader FULL_READER;
    private static final AsfHeaderReader INFO_READER;
    private static final AsfHeaderReader TAG_READER;

    private static InputStream createStream(RandomAccessFile raf) {
        return new FullRequestInputStream(new BufferedInputStream(new RandomAccessFileInputstream(raf)));
    }

    public static AsfHeader readHeader(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        AsfHeader result = (AsfHeader)FULL_READER.read(Utils.readGUID(stream), stream, 0L);
        ((InputStream)stream).close();
        return result;
    }

    public static AsfHeader readHeader(RandomAccessFile file) throws IOException {
        InputStream stream = AsfHeaderReader.createStream(file);
        return (AsfHeader)FULL_READER.read(Utils.readGUID(stream), stream, 0L);
    }

    public static AsfHeader readInfoHeader(RandomAccessFile file) throws IOException {
        InputStream stream = AsfHeaderReader.createStream(file);
        return (AsfHeader)INFO_READER.read(Utils.readGUID(stream), stream, 0L);
    }

    public static AsfHeader readTagHeader(RandomAccessFile file) throws IOException {
        InputStream stream = AsfHeaderReader.createStream(file);
        return (AsfHeader)TAG_READER.read(Utils.readGUID(stream), stream, 0L);
    }

    public AsfHeaderReader(List<Class<? extends ChunkReader>> toRegister, boolean readChunkOnce) {
        super(toRegister, readChunkOnce);
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    protected AsfHeader createContainer(long streamPosition, BigInteger chunkLength, InputStream stream) throws IOException {
        long chunkCount = Utils.readUINT32(stream);
        if (stream.read() != 1) {
            throw new IOException("No ASF");
        }
        if (stream.read() != 2) {
            throw new IOException("No ASF");
        }
        return new AsfHeader(streamPosition, chunkLength, chunkCount);
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    public void setExtendedHeaderReader(AsfExtHeaderReader extReader) {
        for (GUID curr : extReader.getApplyingIds()) {
            this.readerMap.put(curr, extReader);
        }
    }

    static {
        ArrayList<Class<? extends ChunkReader>> readers = new ArrayList<Class<? extends ChunkReader>>();
        readers.add(FileHeaderReader.class);
        readers.add(StreamChunkReader.class);
        INFO_READER = new AsfHeaderReader(readers, true);
        readers.clear();
        readers.add(ContentDescriptionReader.class);
        readers.add(ContentBrandingReader.class);
        readers.add(LanguageListReader.class);
        readers.add(MetadataReader.class);
        AsfExtHeaderReader extReader = new AsfExtHeaderReader(readers, true);
        AsfExtHeaderReader extReader2 = new AsfExtHeaderReader(readers, true);
        TAG_READER = new AsfHeaderReader(readers, true);
        TAG_READER.setExtendedHeaderReader(extReader);
        readers.add(FileHeaderReader.class);
        readers.add(StreamChunkReader.class);
        readers.add(EncodingChunkReader.class);
        readers.add(EncryptionChunkReader.class);
        readers.add(StreamBitratePropertiesReader.class);
        FULL_READER = new AsfHeaderReader(readers, false);
        FULL_READER.setExtendedHeaderReader(extReader2);
    }
}

