/*
 * Decompiled with CFR 0.152.
 */
package liquibase.statement;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.ColumnConfig;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.PreparedStatementFactory;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.statement.ExecutablePreparedStatement;
import liquibase.util.StreamUtil;
import liquibase.util.file.FilenameUtils;

public abstract class ExecutablePreparedStatementBase
implements ExecutablePreparedStatement {
    protected Database database;
    private String catalogName;
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns;
    private ChangeSet changeSet;

    protected ExecutablePreparedStatementBase(Database database, String catalogName, String schemaName, String tableName, List<ColumnConfig> columns, ChangeSet changeSet) {
        this.database = database;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columns = columns;
        this.changeSet = changeSet;
    }

    @Override
    public void execute(PreparedStatementFactory factory) throws DatabaseException {
        ArrayList<ColumnConfig> cols = new ArrayList<ColumnConfig>(this.getColumns().size());
        String sql = this.generateSql(cols);
        PreparedStatement stmt = factory.create(sql);
        try {
            int i = 1;
            for (ColumnConfig col : cols) {
                this.applyColumnParameter(stmt, i, col);
                ++i;
            }
            stmt.execute();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    protected abstract String generateSql(List<ColumnConfig> var1);

    private void applyColumnParameter(PreparedStatement stmt, int i, ColumnConfig col) throws SQLException, DatabaseException {
        if (col.getValue() != null) {
            stmt.setString(i, col.getValue());
        } else if (col.getValueBoolean() != null) {
            stmt.setBoolean(i, col.getValueBoolean());
        } else if (col.getValueNumeric() != null) {
            Number number = col.getValueNumeric();
            if (number instanceof Long) {
                stmt.setLong(i, number.longValue());
            } else if (number instanceof Integer) {
                stmt.setInt(i, number.intValue());
            } else if (number instanceof Double) {
                stmt.setDouble(i, number.doubleValue());
            } else if (number instanceof Float) {
                stmt.setFloat(i, number.floatValue());
            } else if (number instanceof BigDecimal) {
                stmt.setBigDecimal(i, (BigDecimal)number);
            } else if (number instanceof BigInteger) {
                stmt.setInt(i, number.intValue());
            }
        } else if (col.getValueDate() != null) {
            stmt.setDate(i, new Date(col.getValueDate().getTime()));
        } else if (col.getValueBlobFile() != null) {
            try {
                String filePath = this.getAbsolutePath(col.getValueBlobFile());
                File file = new File(filePath);
                stmt.setBinaryStream(i, (InputStream)new BufferedInputStream(new FileInputStream(file)), (int)file.length());
            }
            catch (FileNotFoundException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        } else if (col.getValueClobFile() != null) {
            try {
                String filePath = this.getAbsolutePath(col.getValueClobFile());
                File file = new File(filePath);
                BufferedReader bufReader = new BufferedReader(new FileReader(file));
                if (this.database instanceof PostgresDatabase) {
                    String text = StreamUtil.getReaderContents(bufReader);
                    stmt.setString(i, text);
                }
                stmt.setCharacterStream(i, bufReader);
            }
            catch (FileNotFoundException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        } else {
            stmt.setNull(i, 0);
        }
    }

    public String getAbsolutePath(String path) {
        String p = path;
        File f = new File(p);
        if (!f.isAbsolute()) {
            String basePath = FilenameUtils.getFullPath(this.changeSet.getChangeLog().getPhysicalFilePath());
            p = FilenameUtils.normalize(basePath + p);
        }
        return p;
    }

    @Override
    public boolean skipOnUnsupported() {
        return false;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }
}

