/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.Architecture;
import com.openexchange.obs.api.BlockMode;
import com.openexchange.obs.api.BuildTrigger;
import com.openexchange.obs.api.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Repository {
    private final String name;
    private final BuildTrigger rebuild;
    private final BlockMode block;
    private List<Path> path = new ArrayList<Path>();
    private final Set<Architecture> arch = new HashSet<Architecture>();

    public Repository(String name, Path path, Architecture arch, BuildTrigger rebuild, BlockMode block) {
        this(name, Arrays.asList(path), Arrays.asList(arch), rebuild, block);
    }

    public Repository(String name, Path path, Collection<Architecture> arch, BuildTrigger rebuild, BlockMode block) {
        this(name, Arrays.asList(path), arch, rebuild, block);
    }

    public Repository(String name, Collection<Path> path, Collection<Architecture> arch, BuildTrigger rebuild, BlockMode block) {
        this.name = name;
        this.rebuild = rebuild;
        this.block = block;
        this.path.addAll(path);
        this.arch.addAll(arch);
    }

    public String getName() {
        return this.name;
    }

    public BuildTrigger getRebuild() {
        return this.rebuild;
    }

    public BlockMode getBlock() {
        return this.block;
    }

    public Path[] getPaths() {
        return this.path.toArray(new Path[this.path.size()]);
    }

    public Set<Architecture> getArch() {
        return Collections.unmodifiableSet(this.arch);
    }

    public void addPath(Path myPath) {
        this.path.add(myPath);
    }

    public void addPaths(Path[] paths) {
        for (Path p : paths) {
            this.path.add(p);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arch == null ? 0 : this.arch.hashCode());
        result = 31 * result + (this.block == null ? 0 : this.block.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.rebuild == null ? 0 : this.rebuild.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Repository other = (Repository)obj;
        if (!this.arch.equals(other.arch)) {
            return false;
        }
        if (!this.block.equals((Object)other.block)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return this.rebuild.equals((Object)other.rebuild);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name + " " + this.arch.toString() + " ");
        for (Path p : this.getPaths()) {
            sb.append(p.toString());
        }
        return sb.toString();
    }
}

