/*
 * Decompiled with CFR 0.152.
 */
package jcckit.util;

import java.awt.Color;
import java.util.StringTokenizer;
import jcckit.util.ConfigData;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;

public class ConfigParameters {
    private final ConfigData _configData;

    public ConfigParameters(ConfigData configData) {
        this._configData = configData;
    }

    public String getFullKey(String string) {
        return this._configData.getFullKey(string);
    }

    public String get(String string) {
        String string2 = this._configData.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException(this.getFullKey(string));
        }
        return string2;
    }

    public String get(String string, String string2) {
        String string3 = this._configData.get(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public boolean getBoolean(String string) {
        return this.parseBoolean(this.get(string), string);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this._configData.get(string);
        return string2 == null ? bl : this.parseBoolean(string2, string);
    }

    private boolean parseBoolean(String string, String string2) {
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return false;
        }
        throw this.createNumberFormatException("boolean", string, string2);
    }

    private NumberFormatException createNumberFormatException(String string, String string2, String string3) {
        return new NumberFormatException("Not a " + string + ": " + this.getFullKey(string3) + " = " + string2);
    }

    public int getInt(String string) {
        return this.parseInt(this.get(string), string);
    }

    public int getInt(String string, int n) {
        String string2 = this._configData.get(string);
        return string2 == null ? n : this.parseInt(string2, string);
    }

    private int parseInt(String string, String string2) {
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createNumberFormatException("number", string, string2);
        }
    }

    public double getDouble(String string) {
        return this.parseDouble(this.get(string), string);
    }

    public double getDouble(String string, double d) {
        String string2 = this._configData.get(string);
        return string2 == null ? d : this.parseDouble(string2, string);
    }

    private double parseDouble(String string, String string2) {
        try {
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createNumberFormatException("number", string, string2);
        }
    }

    public double[] getDoubleArray(String string) {
        return this.parseDoubleArray(this.get(string), string);
    }

    public double[] getDoubleArray(String string, double[] dArray) {
        String string2 = this._configData.get(string);
        return string2 == null ? dArray : this.parseDoubleArray(string2, string);
    }

    private double[] parseDoubleArray(String string, String string2) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            double[] dArray = new double[stringTokenizer.countTokens()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = new Double(stringTokenizer.nextToken());
            }
            return dArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createNumberFormatException("sequence of numbers", string, string2);
        }
    }

    public Color getColor(String string) {
        return this.parseColor(this.get(string), string);
    }

    public Color getColor(String string, Color color) {
        String string2 = this._configData.get(string);
        return string2 == null ? color : this.parseColor(string2, string);
    }

    private Color parseColor(String string, String string2) {
        try {
            return string.length() == 0 ? null : this.decodeInternal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createNumberFormatException("number", string, string2);
        }
    }

    private Color decodeInternal(String string) {
        if (HtmlColorUtils.getColorIfValid(string) != null) {
            return new ColorMapperIdentity().getMappedColor(HtmlColorUtils.getColorIfValid(string));
        }
        return Color.decode(string);
    }

    public ConfigParameters getNode(String string) {
        return new ConfigParameters(this._configData.getNode(string));
    }
}

