/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.util.concurrent.Callable;
import org.fishwife.jrugged.ServiceWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatencyTracker
implements ServiceWrapper {
    private long lastSuccessMillis;
    private long lastFailureMillis;

    @Override
    public <T> T invoke(Callable<T> c) throws Exception {
        long start = System.currentTimeMillis();
        try {
            T result = c.call();
            this.lastSuccessMillis = System.currentTimeMillis() - start;
            return result;
        }
        catch (Exception e) {
            this.lastFailureMillis = System.currentTimeMillis() - start;
            throw e;
        }
    }

    @Override
    public void invoke(Runnable r) throws Exception {
        long start = System.currentTimeMillis();
        try {
            r.run();
            this.lastSuccessMillis = System.currentTimeMillis() - start;
        }
        catch (Exception e) {
            this.lastFailureMillis = System.currentTimeMillis() - start;
            throw e;
        }
    }

    @Override
    public <T> T invoke(Runnable r, T result) throws Exception {
        long start = System.currentTimeMillis();
        try {
            r.run();
            this.lastSuccessMillis = System.currentTimeMillis() - start;
            return result;
        }
        catch (Exception e) {
            this.lastFailureMillis = System.currentTimeMillis() - start;
            throw e;
        }
    }

    public long getLastSuccessMillis() {
        return this.lastSuccessMillis;
    }

    public long getLastFailureMillis() {
        return this.lastFailureMillis;
    }
}

