/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Impp;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImppScribe
extends VCardPropertyScribe<Impp> {
    public static final String AIM = "aim";
    public static final String ICQ = "icq";
    public static final String IRC = "irc";
    public static final String MSN = "msnim";
    public static final String SIP = "sip";
    public static final String SKYPE = "skype";
    public static final String XMPP = "xmpp";
    public static final String YAHOO = "ymsgr";
    private static final List<HtmlLinkFormat> htmlLinkFormats;

    public ImppScribe() {
        super(Impp.class, "IMPP");
    }

    @Override
    protected void _prepareParameters(Impp property, VCardParameters copy, VCardVersion version, VCard vcard) {
        ImppScribe.handlePrefParam(property, copy, version, vcard);
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.URI;
    }

    @Override
    protected String _writeText(Impp property, VCardVersion version) {
        return this.write(property);
    }

    @Override
    protected Impp _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = ImppScribe.unescape(value);
        return this.parse(value);
    }

    @Override
    protected void _writeXml(Impp property, XCardElement parent) {
        parent.append(VCardDataType.URI, this.write(property));
    }

    @Override
    protected Impp _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String value = element.first(VCardDataType.URI);
        if (value != null) {
            return this.parse(value);
        }
        throw ImppScribe.missingXmlElements(VCardDataType.URI);
    }

    @Override
    protected Impp _parseHtml(HCardElement element, List<String> warnings) {
        String href = element.attr("href");
        if (href.length() == 0) {
            href = element.value();
        }
        try {
            URI uri = this.parseHtmlLink(href);
            if (uri == null) {
                throw new IllegalArgumentException();
            }
            return new Impp(uri);
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(14, href);
        }
    }

    @Override
    protected JCardValue _writeJson(Impp property) {
        return JCardValue.single(this.write(property));
    }

    @Override
    protected Impp _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, List<String> warnings) {
        return this.parse(value.asSingle());
    }

    private String write(Impp property) {
        URI uri = property.getUri();
        return uri == null ? "" : uri.toASCIIString();
    }

    private Impp parse(String value) {
        if (value == null || value.length() == 0) {
            return new Impp((URI)null);
        }
        try {
            return new Impp(value);
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(15, value, e.getMessage());
        }
    }

    public URI parseHtmlLink(String linkUri) {
        for (HtmlLinkFormat format : htmlLinkFormats) {
            String handle = format.parseHandle(linkUri);
            if (handle == null) continue;
            try {
                return new URI(format.getProtocol(), handle, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public String writeHtmlLink(Impp property) {
        URI uri = property.getUri();
        if (uri == null) {
            return null;
        }
        String protocol = uri.getScheme();
        String handle = uri.getSchemeSpecificPart();
        for (HtmlLinkFormat format : htmlLinkFormats) {
            if (!protocol.equals(format.getProtocol())) continue;
            return format.buildLink(handle);
        }
        return uri.toASCIIString();
    }

    static {
        ArrayList<HtmlLinkFormat> list = new ArrayList<HtmlLinkFormat>();
        list.add(new HtmlLinkFormat(AIM, "(goim|addbuddy)\\?.*?\\bscreenname=(.*?)(&|$)", 2, "goim?screenname=%s"));
        list.add(new HtmlLinkFormat(YAHOO, "(sendim|addfriend|sendfile|call)\\?(.*)", 2, "sendim?%s"));
        list.add(new HtmlLinkFormat(SKYPE, "(.*?)(\\?|$)", 1, "%s"));
        list.add(new HtmlLinkFormat(MSN, "(chat|add|voice|video)\\?contact=(.*?)(&|$)", 2, "chat?contact=%s"));
        list.add(new HtmlLinkFormat(XMPP, "(.*?)(\\?|$)", 1, "%s?message"));
        list.add(new HtmlLinkFormat(ICQ, "message\\?uin=(\\d+)", 1, "message?uin=%s"));
        list.add(new HtmlLinkFormat(SIP));
        list.add(new HtmlLinkFormat(IRC));
        htmlLinkFormats = Collections.unmodifiableList(list);
    }

    private static class HtmlLinkFormat {
        private final Pattern parseRegex;
        private final String protocol;
        private final int handleGroup;
        private final String linkFormat;

        public HtmlLinkFormat(String protocol) {
            this(protocol, "(.*)", 1, "%s");
        }

        public HtmlLinkFormat(String protocol, String linkRegex, int handleGroup, String linkFormat) {
            this.parseRegex = Pattern.compile('^' + protocol + ':' + linkRegex, 2);
            this.protocol = protocol;
            this.handleGroup = handleGroup;
            this.linkFormat = protocol + ':' + linkFormat;
        }

        public String parseHandle(String linkUri) {
            Matcher m = this.parseRegex.matcher(linkUri);
            return m.find() ? m.group(this.handleGroup) : null;
        }

        public String buildLink(String handle) {
            return String.format(this.linkFormat, handle);
        }

        public String getProtocol() {
            return this.protocol;
        }
    }
}

