/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.io.json.JCardDeserializer;
import ezvcard.io.json.JCardSerializer;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.property.VCardProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCardModule
extends SimpleModule {
    private static final long serialVersionUID = 6545279961222677077L;
    private static final String MODULE_NAME = "ez-vcard-jcard";
    private static final Version MODULE_VERSION = JCardModule.moduleVersion();
    private final JCardDeserializer deserializer = new JCardDeserializer();
    private final JCardSerializer serializer = new JCardSerializer();
    private ScribeIndex index;

    public JCardModule() {
        super(MODULE_NAME, MODULE_VERSION);
        this.setScribeIndex(new ScribeIndex());
        this.addSerializer((JsonSerializer)this.serializer);
        this.addDeserializer(VCard.class, this.deserializer);
    }

    private static Version moduleVersion() {
        String[] split = Ezvcard.VERSION.split("[.-]");
        if (split.length < 3) {
            return new Version(0, 0, 0, "", Ezvcard.GROUP_ID, Ezvcard.ARTIFACT_ID);
        }
        int major = Integer.parseInt(split[0]);
        int minor = Integer.parseInt(split[1]);
        int patch = Integer.parseInt(split[2]);
        String snapshot = split.length > 3 ? split[3] : "RELEASE";
        return new Version(major, minor, patch, snapshot, Ezvcard.GROUP_ID, Ezvcard.ARTIFACT_ID);
    }

    public boolean isAddProdId() {
        return this.serializer.isAddProdId();
    }

    public void setAddProdId(boolean addProdId) {
        this.serializer.setAddProdId(addProdId);
    }

    public boolean isVersionStrict() {
        return this.serializer.isVersionStrict();
    }

    public void setVersionStrict(boolean versionStrict) {
        this.serializer.setVersionStrict(versionStrict);
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
        this.serializer.setScribeIndex(index);
        this.deserializer.setScribeIndex(index);
    }
}

