/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.chain;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.io.chain.ChainingWriter;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.VCardWriter;
import ezvcard.property.VCardProperty;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingTextWriter
extends ChainingWriter<ChainingTextWriter> {
    private VCardVersion version;
    private boolean caretEncoding = false;
    private boolean outlook = false;

    public ChainingTextWriter(Collection<VCard> vcards) {
        super(vcards);
    }

    public ChainingTextWriter version(VCardVersion version) {
        this.version = version;
        return this;
    }

    public ChainingTextWriter caretEncoding(boolean enable) {
        this.caretEncoding = enable;
        return this;
    }

    public ChainingTextWriter outlook(boolean enable) {
        this.outlook = enable;
        return this;
    }

    @Override
    public ChainingTextWriter prodId(boolean include) {
        return (ChainingTextWriter)super.prodId(include);
    }

    @Override
    public ChainingTextWriter versionStrict(boolean versionStrict) {
        return (ChainingTextWriter)super.versionStrict(versionStrict);
    }

    @Override
    public ChainingTextWriter register(VCardPropertyScribe<? extends VCardProperty> scribe) {
        return (ChainingTextWriter)super.register(scribe);
    }

    public String go() {
        StringWriter sw = new StringWriter();
        try {
            this.go(sw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public void go(OutputStream out) throws IOException {
        this.go(new VCardWriter(out, this.version));
    }

    public void go(File file) throws IOException {
        this.go(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go(File file, boolean append) throws IOException {
        VCardWriter writer = new VCardWriter(file, append, this.version);
        try {
            this.go(writer);
        }
        finally {
            writer.close();
        }
    }

    public void go(Writer writer) throws IOException {
        this.go(new VCardWriter(writer, this.version));
    }

    private void go(VCardWriter writer) throws IOException {
        writer.setAddProdId(this.prodId);
        writer.setCaretEncodingEnabled(this.caretEncoding);
        writer.setVersionStrict(this.versionStrict);
        writer.setOutlookCompatibility(this.outlook);
        if (this.index != null) {
            writer.setScribeIndex(this.index);
        }
        for (VCard vcard : this.vcards) {
            if (this.version == null) {
                VCardVersion vcardVersion = vcard.getVersion();
                if (vcardVersion == null) {
                    vcardVersion = VCardVersion.V3_0;
                }
                writer.setTargetVersion(vcardVersion);
            }
            writer.write(vcard);
            writer.flush();
        }
    }
}

