/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.ascii.SocketTextReader;
import com.hazelcast.nio.tcp.AbstractSelectionHandler;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.SocketClientDataReader;
import com.hazelcast.nio.tcp.SocketClientMessageReader;
import com.hazelcast.nio.tcp.SocketPacketReader;
import com.hazelcast.nio.tcp.SocketReader;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.WriteHandler;
import com.hazelcast.util.Clock;
import com.hazelcast.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;

public final class ReadHandler
extends AbstractSelectionHandler {
    private ByteBuffer inputBuffer;
    private SocketReader socketReader;
    private volatile long lastHandle;
    private volatile long eventCount;

    public ReadHandler(TcpIpConnection connection, IOSelector ioSelector) {
        super(connection, ioSelector, 1);
        this.ioSelector = ioSelector;
    }

    public void start() {
        this.ioSelector.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                ReadHandler.this.getSelectionKey();
            }
        });
    }

    @Override
    public long getEventCount() {
        return this.eventCount;
    }

    @Override
    public void requestMigration(IOSelector newOwner) {
        this.ioSelector.addTaskAndWakeup(new StartMigrationTask(newOwner));
    }

    @Override
    @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="eventCount is accessed by a single thread only.")
    public void handle() {
        ++this.eventCount;
        this.lastHandle = Clock.currentTimeMillis();
        if (!this.connection.isAlive()) {
            String message = "We are being asked to read, but connection is not live so we won't";
            this.logger.finest(message);
            return;
        }
        try {
            int readBytes;
            if (this.socketReader == null) {
                this.initializeSocketReader();
                if (this.socketReader == null) {
                    return;
                }
            }
            if ((readBytes = this.socketChannel.read(this.inputBuffer)) == -1) {
                throw new EOFException("Remote socket closed!");
            }
        }
        catch (Throwable e) {
            this.handleSocketException(e);
            return;
        }
        try {
            if (this.inputBuffer.position() == 0) {
                return;
            }
            this.inputBuffer.flip();
            this.socketReader.read(this.inputBuffer);
            if (this.inputBuffer.hasRemaining()) {
                this.inputBuffer.compact();
            } else {
                this.inputBuffer.clear();
            }
        }
        catch (Throwable t) {
            this.handleSocketException(t);
        }
    }

    private void initializeSocketReader() throws IOException {
        if (this.socketReader == null) {
            ByteBuffer protocolBuffer = ByteBuffer.allocate(3);
            int readBytes = this.socketChannel.read(protocolBuffer);
            if (readBytes == -1) {
                throw new EOFException("Could not read protocol type!");
            }
            if (readBytes == 0 && this.connectionManager.isSSLEnabled()) {
                return;
            }
            if (!protocolBuffer.hasRemaining()) {
                String protocol = StringUtil.bytesToString(protocolBuffer.array());
                WriteHandler writeHandler = this.connection.getWriteHandler();
                if ("HZC".equals(protocol)) {
                    this.configureBuffers(this.connectionManager.socketReceiveBufferSize);
                    this.connection.setType(ConnectionType.MEMBER);
                    writeHandler.setProtocol("HZC");
                    this.socketReader = new SocketPacketReader(this.connection);
                } else if ("CB1".equals(protocol)) {
                    this.configureBuffers(this.connectionManager.socketClientReceiveBufferSize);
                    writeHandler.setProtocol("CB1");
                    this.socketReader = new SocketClientDataReader(this.connection);
                } else if ("CB2".equals(protocol)) {
                    this.configureBuffers(this.connectionManager.socketClientReceiveBufferSize);
                    writeHandler.setProtocol("CB2");
                    this.socketReader = new SocketClientMessageReader(this.connection, this.socketChannel);
                } else {
                    this.configureBuffers(this.connectionManager.socketClientReceiveBufferSize);
                    writeHandler.setProtocol("TXT");
                    this.inputBuffer.put(protocolBuffer.array());
                    this.socketReader = new SocketTextReader(this.connection);
                    this.connection.getConnectionManager().incrementTextConnections();
                }
            }
            if (this.socketReader == null) {
                throw new IOException("Could not initialize SocketReader!");
            }
        }
    }

    private void configureBuffers(int size) {
        this.inputBuffer = ByteBuffer.allocate(size);
        try {
            this.connection.setReceiveBufferSize(size);
        }
        catch (SocketException e) {
            this.logger.finest("Failed to adjust TCP receive buffer of " + this.connection + " to " + size + " B.", e);
        }
    }

    long getLastHandle() {
        return this.lastHandle;
    }

    void shutdown() {
        this.ioSelector.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                try {
                    ReadHandler.this.socketChannel.closeInbound();
                }
                catch (IOException e) {
                    ReadHandler.this.logger.finest("Error while closing inbound", e);
                }
            }
        });
    }

    private class StartMigrationTask
    implements Runnable {
        private final IOSelector newOwner;

        public StartMigrationTask(IOSelector newOwner) {
            this.newOwner = newOwner;
        }

        @Override
        public void run() {
            if (ReadHandler.this.ioSelector == this.newOwner) {
                return;
            }
            ReadHandler.this.startMigration(this.newOwner);
        }
    }
}

