/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.concurrent.countdownlatch.client.AwaitRequest;
import com.hazelcast.concurrent.countdownlatch.client.CountDownRequest;
import com.hazelcast.concurrent.countdownlatch.client.GetCountRequest;
import com.hazelcast.concurrent.countdownlatch.client.SetCountRequest;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.nio.serialization.Data;
import java.util.concurrent.TimeUnit;

public class ClientCountDownLatchProxy
extends ClientProxy
implements ICountDownLatch {
    private volatile Data key;

    public ClientCountDownLatchProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        AwaitRequest request = new AwaitRequest(this.getName(), this.getTimeInMillis(timeout, unit));
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public void countDown() {
        CountDownRequest request = new CountDownRequest(this.getName());
        this.invoke(request);
    }

    @Override
    public int getCount() {
        GetCountRequest request = new GetCountRequest(this.getName());
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public boolean trySetCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count can't be negative");
        }
        SetCountRequest request = new SetCountRequest(this.getName(), count);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.toData(this.getName());
        }
        return this.key;
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    protected <T> T invoke(ClientRequest req) {
        return super.invoke(req, this.getKey());
    }

    public String toString() {
        return "ICountDownLatch{name='" + this.getName() + '\'' + '}';
    }
}

