/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class MapPutAllCodec {
    public static final MapMessageType REQUEST_TYPE = MapMessageType.MAP_PUTALL;
    public static final int RESPONSE_TYPE = 100;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, Map<Data, Data> entries) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, entries);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(name);
        Set<Data> entries_keySet = entries.keySet();
        clientMessage.set(entries_keySet.size());
        for (Data entries_keySet_item : entries_keySet) {
            clientMessage.set(entries_keySet_item);
        }
        Collection<Data> entries_values = entries.values();
        clientMessage.set(entries_values.size());
        for (Data entries_values_item : entries_values) {
            clientMessage.set(entries_values_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        HashMap<Data, Data> entries = null;
        int entries_keySet_size = clientMessage.getInt();
        ArrayList<Data> entries_keySet = new ArrayList<Data>(entries_keySet_size);
        for (int entries_keySet_index = 0; entries_keySet_index < entries_keySet_size; ++entries_keySet_index) {
            Data entries_keySet_item = clientMessage.getData();
            entries_keySet.add(entries_keySet_item);
        }
        int entries_values_size = clientMessage.getInt();
        ArrayList<Data> entries_values = new ArrayList<Data>(entries_values_size);
        for (int entries_values_index = 0; entries_values_index < entries_values_size; ++entries_values_index) {
            Data entries_values_item = clientMessage.getData();
            entries_values.add(entries_values_item);
        }
        entries = new HashMap<Data, Data>();
        for (int entries_index = 0; entries_index < entries_keySet_size; ++entries_index) {
            entries.put((Data)entries_keySet.get(entries_index), (Data)entries_values.get(entries_index));
        }
        parameters.entries = entries;
        return parameters;
    }

    public static ClientMessage encodeResponse() {
        int requiredDataSize = ResponseParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(100);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        return parameters;
    }

    public static class ResponseParameters {
        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final MapMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Map<Data, Data> entries;

        public static int calculateDataSize(String name, Map<Data, Data> entries) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateStringDataSize(name);
            Set<Data> entries_keySet = entries.keySet();
            dataSize += 4;
            for (Data entries_keySet_item : entries_keySet) {
                dataSize += ParameterUtil.calculateDataSize(entries_keySet_item);
            }
            Collection<Data> entries_values = entries.values();
            dataSize += 4;
            for (Data entries_values_item : entries_values) {
                dataSize += ParameterUtil.calculateDataSize(entries_values_item);
            }
            return dataSize;
        }
    }
}

