/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.values.IcalObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IcalSchema {
    private final Map<String, ParamRule> paramRules;
    private final Map<String, ContentRule> contentRules;
    private final Map<String, ObjectRule> objectRules;
    private final Map<String, XformRule> xformRules;
    private final List<String> ruleStack = new ArrayList<String>();
    private static final Pattern EXTENSION_PARAM_NAME_RE = Pattern.compile("^X-[A-Z0-9\\-]+$", 2);

    IcalSchema(Map<String, ParamRule> paramRules, Map<String, ContentRule> contentRules, Map<String, ObjectRule> objectRules, Map<String, XformRule> xformRules) {
        this.paramRules = paramRules;
        this.contentRules = contentRules;
        this.objectRules = objectRules;
        this.xformRules = xformRules;
    }

    public void applyParamsSchema(String rule, Map<String, String> params, IcalObject out) throws ParseException {
        for (Map.Entry<String, String> param : params.entrySet()) {
            String name = param.getKey();
            this.applyParamSchema(rule, name, param.getValue(), out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyParamSchema(String rule, String name, String value, IcalObject out) throws ParseException {
        if (EXTENSION_PARAM_NAME_RE.matcher(name).find()) {
            out.getExtParams().put(name, value);
            return;
        }
        this.ruleStack.add(rule);
        try {
            this.paramRules.get(rule).apply(this, name, value, out);
        }
        finally {
            this.ruleStack.remove(this.ruleStack.get(this.ruleStack.size() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyContentSchema(String rule, String content, IcalObject out) throws ParseException {
        this.ruleStack.add(rule);
        try {
            try {
                this.contentRules.get(rule).apply(this, content, out);
            }
            catch (NumberFormatException ex) {
                this.badContent(content);
            }
            catch (IllegalArgumentException ex) {
                this.badContent(content);
            }
        }
        finally {
            this.ruleStack.remove(this.ruleStack.get(this.ruleStack.size() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyObjectSchema(String rule, Map<String, String> params, String content, IcalObject out) throws ParseException {
        this.ruleStack.add(rule);
        try {
            this.objectRules.get(rule).apply(this, params, content, out);
        }
        finally {
            this.ruleStack.remove(this.ruleStack.get(this.ruleStack.size() - 1));
        }
    }

    public Object applyXformSchema(String rule, String content) throws ParseException {
        this.ruleStack.add(rule);
        try {
            Object object = this.xformRules.get(rule).apply(this, content);
            return object;
        }
        catch (NumberFormatException ex) {
            this.badContent(content);
        }
        catch (IllegalArgumentException ex) {
            this.badContent(content);
        }
        {
            throw new AssertionError();
        }
        finally {
            this.ruleStack.remove(this.ruleStack.get(this.ruleStack.size() - 1));
        }
    }

    public void badParam(String name, String value) throws ParseException {
        throw new ParseException("parameter " + name + " has bad value [[" + value + "]] in " + this.ruleStack, 0);
    }

    public void badPart(String part, String msg) throws ParseException {
        msg = null != msg ? " : " + msg : "";
        throw new ParseException("cannot parse [[" + part + "]] in " + this.ruleStack + msg, 0);
    }

    public void dupePart(String part) throws ParseException {
        throw new ParseException("duplicate part [[" + part + "]] in " + this.ruleStack, 0);
    }

    public void missingPart(String partName, String content) throws ParseException {
        throw new ParseException("missing part " + partName + " from [[" + content + "]] in " + this.ruleStack, 0);
    }

    public void badContent(String content) throws ParseException {
        throw new ParseException("cannot parse content line [[" + content + "]] in " + this.ruleStack, 0);
    }

    public static interface XformRule {
        public Object apply(IcalSchema var1, String var2) throws ParseException;
    }

    public static interface ContentRule {
        public void apply(IcalSchema var1, String var2, IcalObject var3) throws ParseException;
    }

    public static interface ParamRule {
        public void apply(IcalSchema var1, String var2, String var3, IcalObject var4) throws ParseException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ObjectRule {
        public void apply(IcalSchema var1, Map<String, String> var2, String var3, IcalObject var4) throws ParseException;
    }
}

