/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;

public class SequenceMonitor {
    private static final long DEFAULT_MONITOR_INTERVAL = 60000L;
    private static final Logger LOG = LogUtils.getL7dLogger(SequenceMonitor.class);
    private long monitorInterval = 60000L;
    private long firstCheck;
    private List<Long> receiveTimes = new ArrayList<Long>();

    public void acknowledgeMessage() {
        long now = System.currentTimeMillis();
        if (0L == this.firstCheck) {
            this.firstCheck = now + this.monitorInterval;
        }
        this.receiveTimes.add(new Long(now));
    }

    public int getMPM() {
        long now = System.currentTimeMillis();
        int mpm = 0;
        if (this.firstCheck > 0L && now >= this.firstCheck) {
            long threshold = now - this.monitorInterval;
            while (!this.receiveTimes.isEmpty() && this.receiveTimes.get(0) <= threshold) {
                this.receiveTimes.remove(0);
            }
            mpm = this.receiveTimes.size();
        }
        return mpm;
    }

    public synchronized long getLastArrivalTime() {
        if (this.receiveTimes.size() > 0) {
            return this.receiveTimes.get(this.receiveTimes.size() - 1);
        }
        return 0L;
    }

    protected void setMonitorInterval(long i) {
        if (this.receiveTimes.size() == 0) {
            this.firstCheck = 0L;
            this.monitorInterval = i;
        } else {
            LOG.warning("Cannot change monitor interval at this point.");
        }
    }
}

