/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.BuildServiceException;

public enum DebianRelease {
    Lenny,
    Squeeze,
    Wheezy,
    Jessie,
    Stretch,
    Buster,
    Sid;


    public static DebianRelease byRepositoryName(String name) throws BuildServiceException {
        if (null == name || 0 == name.length()) {
            throw new BuildServiceException("Given repository name is empty.");
        }
        for (DebianRelease release : DebianRelease.values()) {
            if (!name.endsWith(release.name())) continue;
            return release;
        }
        throw new BuildServiceException("Unknown Debian release: \"" + name + "\"");
    }

    public boolean isNewer(DebianRelease other) {
        return this.ordinal() > other.ordinal();
    }
}

