/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.shell;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import org.apache.felix.gogo.options.Option;
import org.apache.felix.gogo.options.Options;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;

public class Telnet
implements Runnable {
    static final String[] functions = new String[]{"telnetd"};
    private static final int defaultPort = 2019;
    private final CommandProcessor processor;
    private ServerSocket server;
    private Thread thread;
    private boolean quit;
    private int port;
    private String ip;

    public Telnet(CommandProcessor procesor) {
        this.processor = procesor;
    }

    public void telnetd(String[] argv) throws IOException {
        String[] usage = new String[]{"telnetd - start simple telnet server", "Usage: telnetd [-i ip] [-p port] start | stop | status", "  -i --ip=INTERFACE        listen interface (default=127.0.0.1)", "  -p --port=PORT           listen port (default=2019)", "  -? --help                show help"};
        Option opt = Options.compile(usage).parse(argv);
        List<String> args = opt.args();
        if (opt.isSet("help") || args.isEmpty()) {
            opt.usage();
            return;
        }
        String command = args.get(0);
        if ("start".equals(command)) {
            if (this.server != null) {
                throw new IllegalStateException("telnetd is already running on port " + this.port);
            }
            this.ip = opt.get("ip");
            this.port = opt.getNumber("port");
            this.start();
            this.status();
        } else if ("stop".equals(command)) {
            if (this.server == null) {
                throw new IllegalStateException("telnetd is not running.");
            }
            this.stop();
        } else if ("status".equals(command)) {
            this.status();
        } else {
            throw opt.usageError("bad command: " + command);
        }
    }

    private void status() {
        if (this.server != null) {
            System.out.println("telnetd is running on " + this.ip + ":" + this.port);
        } else {
            System.out.println("telnetd is not running.");
        }
    }

    private void start() throws IOException {
        this.quit = false;
        this.server = new ServerSocket(this.port, 0, InetAddress.getByName(this.ip));
        this.thread = new Thread((Runnable)this, "gogo telnet");
        this.thread.start();
    }

    private void stop() throws IOException {
        this.quit = true;
        this.server.close();
        this.server = null;
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.quit) {
                final Socket socket = this.server.accept();
                PrintStream out = new PrintStream(socket.getOutputStream());
                final CommandSession session = this.processor.createSession(socket.getInputStream(), out, out);
                Thread handler = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            session.execute((CharSequence)"gosh --login --noshutdown");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            session.close();
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                };
                handler.start();
            }
        }
        catch (IOException e) {
            if (!this.quit) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (this.server != null) {
                    this.server.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

