/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.Version;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.draft06.ClosingFrame;

public class WebSocketEngine {
    public static final String SEC_WS_ACCEPT = "Sec-WebSocket-Accept";
    public static final String SEC_WS_KEY_HEADER = "Sec-WebSocket-Key";
    public static final String SEC_WS_ORIGIN_HEADER = "Sec-WebSocket-Origin";
    public static final String ORIGIN_HEADER = "Origin";
    public static final String SEC_WS_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    public static final String SEC_WS_EXTENSIONS_HEADER = "Sec-WebSocket-Extensions";
    public static final String SEC_WS_VERSION = "Sec-WebSocket-Version";
    public static final String WEBSOCKET = "websocket";
    public static final String RESPONSE_CODE_MESSAGE = "Switching Protocols";
    public static final String RESPONSE_CODE_HEADER = "Response Code";
    public static final int RESPONSE_CODE_VALUE = 101;
    public static final String UPGRADE = "upgrade";
    public static final String CONNECTION = "connection";
    public static final String CLIENT_WS_ORIGIN_HEADER = "Origin";
    public static final Version DEFAULT_VERSION = Version.DRAFT17;
    public static final int INITIAL_BUFFER_SIZE = 8192;
    public static final int DEFAULT_TIMEOUT = 30;
    private static final WebSocketEngine engine = new WebSocketEngine();
    static final Logger logger = Logger.getLogger("websocket");
    public static final String SERVER_KEY_HASH = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final int MASK_SIZE = 4;
    private final List<WebSocketApplication> applications = new ArrayList<WebSocketApplication>();
    private final Attribute<WebSocketHolder> webSocketAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("web-socket");
    private final HashMap<WebSocketApplication, String> applicationMap = new HashMap();
    private final HashMap<String, List<WebSocketApplication>> contextApplications = new HashMap();
    private Mapper mapper = new Mapper();

    private WebSocketEngine() {
        this.mapper.setDefaultHostName("localhost");
    }

    public static WebSocketEngine getEngine() {
        return engine;
    }

    public static byte[] toArray(long length) {
        long value = length;
        byte[] b = new byte[8];
        for (int i = 7; i >= 0 && value > 0L; value >>= 8, --i) {
            b[i] = (byte)(value & 0xFFL);
        }
        return b;
    }

    public static long toLong(byte[] bytes, int start, int end) {
        long value = 0L;
        for (int i = start; i < end; ++i) {
            value <<= 8;
            value ^= (long)bytes[i] & 0xFFL;
        }
        return value;
    }

    public static List<String> toString(byte[] bytes) {
        return WebSocketEngine.toString(bytes, 0, bytes.length);
    }

    public static List<String> toString(byte[] bytes, int start, int end) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            list.add(Integer.toHexString(bytes[i] & 0xFF).toUpperCase(Locale.US));
        }
        return list;
    }

    public WebSocketApplication getApplication(HttpRequestPacket request) {
        block4: {
            MappingData data = new MappingData();
            try {
                this.mapper.mapUriWithSemicolon(request.serverName(), request.getRequestURIRef().getDecodedRequestURIBC(), data, 0);
                if (data.wrapper != null) {
                    return (WebSocketApplication)data.wrapper;
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block4;
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        for (WebSocketApplication application : this.applications) {
            if (!application.upgrade(request)) continue;
            return application;
        }
        return null;
    }

    public boolean upgrade(FilterChainContext ctx, HttpContent requestContent) throws IOException {
        block4: {
            HttpRequestPacket request = (HttpRequestPacket)requestContent.getHttpHeader();
            WebSocketApplication app = WebSocketEngine.getEngine().getApplication(request);
            WebSocket socket = null;
            try {
                if (app != null) {
                    ProtocolHandler protocolHandler = WebSocketEngine.loadHandler(request.getHeaders());
                    if (protocolHandler == null) {
                        WebSocketEngine.handleUnsupportedVersion(ctx, request);
                        return false;
                    }
                    Connection connection = ctx.getConnection();
                    protocolHandler.setFilterChainContext(ctx);
                    protocolHandler.setConnection(connection);
                    socket = app.createSocket(protocolHandler, request, app);
                    WebSocketHolder holder = WebSocketEngine.getEngine().setWebSocketHolder(connection, protocolHandler, socket);
                    holder.application = app;
                    protocolHandler.handshake(ctx, app, requestContent);
                    request.getConnection().addCloseListener(new Connection.CloseListener(){

                        public void onClosed(Connection connection, Connection.CloseType type) throws IOException {
                            WebSocket webSocket = WebSocketEngine.this.getWebSocket(connection);
                            webSocket.close();
                            webSocket.onClose(new ClosingFrame(1001, "Close detected on connection"));
                        }
                    });
                    socket.onConnect();
                    return true;
                }
            }
            catch (HandshakeException e) {
                logger.log(Level.FINE, e.getMessage(), e);
                if (socket == null) break block4;
                socket.close();
            }
        }
        return false;
    }

    public static ProtocolHandler loadHandler(MimeHeaders headers) {
        for (Version version : Version.values()) {
            if (!version.validate(headers)) continue;
            return version.createHandler(false);
        }
        return null;
    }

    public synchronized void register(String contextPath, String urlPattern, WebSocketApplication app) {
        String contextPathLocal = WebSocketEngine.getContextPath(contextPath);
        this.mapper.addContext("localhost", contextPathLocal, (Object)app, null, null);
        this.mapper.addWrapper("localhost", contextPathLocal, urlPattern, (Object)app);
        this.applicationMap.put(app, contextPathLocal + '|' + urlPattern);
        if (this.contextApplications.containsKey(contextPathLocal)) {
            this.contextApplications.get(contextPathLocal).add(app);
        } else {
            ArrayList<WebSocketApplication> apps = new ArrayList<WebSocketApplication>(4);
            apps.add(app);
            this.contextApplications.put(contextPathLocal, apps);
        }
    }

    @Deprecated
    public synchronized void register(WebSocketApplication app) {
        this.applications.add(app);
    }

    public synchronized void unregister(WebSocketApplication app) {
        String pattern = this.applicationMap.remove(app);
        if (pattern != null) {
            String[] parts = pattern.split("\\|");
            this.mapper.removeWrapper("localhost", parts[0], parts[1]);
            List<WebSocketApplication> apps = this.contextApplications.get(parts[0]);
            apps.remove(app);
            if (apps.isEmpty()) {
                this.mapper.removeContext("localhost", parts[0]);
            }
            return;
        }
        this.applications.remove(app);
    }

    public synchronized void unregisterAll() {
        this.applicationMap.clear();
        this.contextApplications.clear();
        this.applications.clear();
        this.mapper = new Mapper();
        this.mapper.setDefaultHostName("localhost");
    }

    boolean webSocketInProgress(Connection connection) {
        return this.webSocketAttribute.get((AttributeStorage)connection) != null;
    }

    public WebSocket getWebSocket(Connection connection) {
        WebSocketHolder holder = this.getWebSocketHolder(connection);
        return holder == null ? null : holder.webSocket;
    }

    public WebSocketHolder getWebSocketHolder(Connection connection) {
        return (WebSocketHolder)this.webSocketAttribute.get((AttributeStorage)connection);
    }

    public WebSocketHolder setWebSocketHolder(Connection connection, ProtocolHandler handler, WebSocket socket) {
        WebSocketHolder holder = new WebSocketHolder(handler, socket);
        this.webSocketAttribute.set((AttributeStorage)connection, (Object)holder);
        return holder;
    }

    private static void handleUnsupportedVersion(FilterChainContext ctx, HttpRequestPacket request) throws IOException {
        HttpResponsePacket response = HttpResponsePacket.builder((HttpRequestPacket)request).build();
        response.setStatus(HttpStatus.BAD_REQUEST_400);
        response.addHeader(SEC_WS_VERSION, Version.getSupportedWireProtocolVersions());
        ctx.write((Object)response);
    }

    private static String getContextPath(String mapping) {
        String ctx = "";
        int slash = mapping.indexOf("/", 1);
        ctx = slash != -1 ? mapping.substring(0, slash) : mapping;
        if (ctx.startsWith("/*.") || ctx.startsWith("*.")) {
            ctx = ctx.indexOf("/") == ctx.lastIndexOf("/") ? "" : ctx.substring(1);
        }
        if (ctx.startsWith("/*") || ctx.startsWith("*")) {
            ctx = "";
        }
        if (ctx.equals("/")) {
            ctx = "";
        }
        return ctx;
    }

    public static final class WebSocketHolder {
        public volatile WebSocket webSocket;
        public volatile HandShake handshake;
        public volatile WebSocketApplication application;
        public volatile Buffer buffer;
        public volatile ProtocolHandler handler;

        WebSocketHolder(ProtocolHandler handler, WebSocket socket) {
            this.handler = handler;
            this.webSocket = socket;
        }
    }
}

