/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.javasimon.Counter;
import org.javasimon.CounterSample;
import org.javasimon.Manager;
import org.javasimon.Simon;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.callback.Callback;
import org.javasimon.callback.CompositeCallback;

public final class CompositeCallbackImpl
implements CompositeCallback {
    private List<Callback> callbacks = new CopyOnWriteArrayList<Callback>();
    private Manager manager;

    @Override
    public synchronized void initialize(Manager manager) {
        if (this.manager != null) {
            throw new IllegalStateException("Callback was already initialized");
        }
        this.manager = manager;
        for (Callback callback : this.callbacks) {
            try {
                callback.initialize(manager);
            }
            catch (Exception e) {
                this.onManagerWarning("Callback initialization error", e);
            }
        }
    }

    @Override
    public List<Callback> callbacks() {
        return this.callbacks;
    }

    @Override
    public void addCallback(Callback callback) {
        if (this.manager != null) {
            callback.initialize(this.manager);
        }
        this.callbacks.add(callback);
    }

    @Override
    public void removeCallback(Callback callback) {
        this.callbacks.remove(callback);
        if (this.manager != null) {
            callback.cleanup();
        }
    }

    @Override
    public void removeAllCallbacks() {
        for (Callback callback : this.callbacks) {
            this.removeCallback(callback);
        }
    }

    @Override
    public void cleanup() {
        this.manager = null;
        for (Callback callback : this.callbacks) {
            try {
                callback.cleanup();
            }
            catch (Exception e) {
                this.onManagerWarning("Callback cleanup error", e);
            }
        }
    }

    @Override
    public void onSimonReset(Simon simon) {
        for (Callback callback : this.callbacks) {
            callback.onSimonReset(simon);
        }
    }

    @Override
    public void onStopwatchAdd(Stopwatch stopwatch, Split split, StopwatchSample sample) {
        for (Callback callback : this.callbacks) {
            callback.onStopwatchAdd(stopwatch, split, sample);
        }
    }

    @Override
    public void onStopwatchStart(Split split) {
        for (Callback callback : this.callbacks) {
            callback.onStopwatchStart(split);
        }
    }

    @Override
    public void onStopwatchStop(Split split, StopwatchSample sample) {
        for (Callback callback : this.callbacks) {
            callback.onStopwatchStop(split, sample);
        }
    }

    @Override
    public void onCounterDecrease(Counter counter, long dec, CounterSample sample) {
        for (Callback callback : this.callbacks) {
            callback.onCounterDecrease(counter, dec, sample);
        }
    }

    @Override
    public void onCounterIncrease(Counter counter, long inc, CounterSample sample) {
        for (Callback callback : this.callbacks) {
            callback.onCounterIncrease(counter, inc, sample);
        }
    }

    @Override
    public void onCounterSet(Counter counter, long val, CounterSample sample) {
        for (Callback callback : this.callbacks) {
            callback.onCounterSet(counter, val, sample);
        }
    }

    @Override
    public void onSimonCreated(Simon simon) {
        for (Callback callback : this.callbacks) {
            callback.onSimonCreated(simon);
        }
    }

    @Override
    public void onSimonDestroyed(Simon simon) {
        for (Callback callback : this.callbacks) {
            callback.onSimonDestroyed(simon);
        }
    }

    @Override
    public void onManagerClear() {
        for (Callback callback : this.callbacks) {
            callback.onManagerClear();
        }
    }

    @Override
    public void onManagerMessage(String message) {
        for (Callback callback : this.callbacks) {
            callback.onManagerMessage(message);
        }
    }

    @Override
    public void onManagerWarning(String warning, Exception cause) {
        for (Callback callback : this.callbacks) {
            callback.onManagerWarning(warning, cause);
        }
    }
}

