/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.Encoding;
import ezvcard.parameter.MediaTypeParameter;
import ezvcard.parameter.VCardParameter;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.BinaryProperty;
import ezvcard.util.DataUri;
import ezvcard.util.org.apache.commons.codec.binary.Base64;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryPropertyScribe<T extends BinaryProperty<U>, U extends MediaTypeParameter>
extends VCardPropertyScribe<T> {
    public BinaryPropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                return null;
            }
            case V4_0: {
                return VCardDataType.URI;
            }
        }
        return null;
    }

    @Override
    protected VCardDataType _dataType(T property, VCardVersion version) {
        if (((BinaryProperty)property).getUrl() != null) {
            switch (version) {
                case V2_1: {
                    return VCardDataType.URL;
                }
                case V3_0: 
                case V4_0: {
                    return VCardDataType.URI;
                }
            }
        }
        if (((BinaryProperty)property).getData() != null) {
            switch (version) {
                case V2_1: 
                case V3_0: {
                    return null;
                }
                case V4_0: {
                    return VCardDataType.URI;
                }
            }
        }
        return this._defaultDataType(version);
    }

    @Override
    protected void _prepareParameters(T property, VCardParameters copy, VCardVersion version, VCard vcard) {
        Object contentType = ((BinaryProperty)property).getContentType();
        if (contentType == null) {
            contentType = new MediaTypeParameter(null, null, null);
        }
        if (((BinaryProperty)property).getUrl() != null) {
            copy.setEncoding(null);
            switch (version) {
                case V2_1: {
                    copy.setType(((VCardParameter)contentType).getValue());
                    copy.setMediaType(null);
                    break;
                }
                case V3_0: {
                    copy.setType(((VCardParameter)contentType).getValue());
                    copy.setMediaType(null);
                    break;
                }
                case V4_0: {
                    copy.setMediaType(((MediaTypeParameter)contentType).getMediaType());
                }
            }
            return;
        }
        if (((BinaryProperty)property).getData() != null) {
            copy.setMediaType(null);
            switch (version) {
                case V2_1: {
                    copy.setEncoding(Encoding.BASE64);
                    copy.setType(((VCardParameter)contentType).getValue());
                    break;
                }
                case V3_0: {
                    copy.setEncoding(Encoding.B);
                    copy.setType(((VCardParameter)contentType).getValue());
                    break;
                }
                case V4_0: {
                    copy.setEncoding(null);
                }
            }
            return;
        }
    }

    @Override
    protected String _writeText(T property, VCardVersion version) {
        return this.write(property, version);
    }

    @Override
    protected T _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = BinaryPropertyScribe.unescape(value);
        return this.parse(value, dataType, parameters, version, warnings);
    }

    @Override
    protected void _writeXml(T property, XCardElement parent) {
        parent.append(VCardDataType.URI, this.write(property, parent.version()));
    }

    @Override
    protected T _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String value = element.first(VCardDataType.URI);
        if (value != null) {
            return this.parse(value, VCardDataType.URI, parameters, element.version(), warnings);
        }
        throw BinaryPropertyScribe.missingXmlElements(VCardDataType.URI);
    }

    @Override
    protected T _parseHtml(HCardElement element, List<String> warnings) {
        String elementName = element.tagName();
        if (!"object".equals(elementName)) {
            throw new CannotParseException(1, elementName);
        }
        String data = element.absUrl("data");
        if (data.length() == 0) {
            throw new CannotParseException(2, new Object[0]);
        }
        try {
            DataUri uri = DataUri.parse(data);
            U mediaType = this._mediaTypeFromMediaTypeParameter(uri.getContentType());
            return this._newInstance(uri.getData(), mediaType);
        }
        catch (IllegalArgumentException e) {
            String extension;
            U mediaType = null;
            String type = element.attr("type");
            mediaType = type.length() > 0 ? (U)this._mediaTypeFromMediaTypeParameter(type) : ((extension = BinaryPropertyScribe.getFileExtension(data)) == null ? null : (U)this._mediaTypeFromFileExtension(extension));
            return this._newInstance(data, mediaType);
        }
    }

    @Override
    protected JCardValue _writeJson(T property) {
        return JCardValue.single(this.write(property, VCardVersion.V4_0));
    }

    @Override
    protected T _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, List<String> warnings) {
        String valueStr = value.asSingle();
        return this.parse(valueStr, dataType, parameters, VCardVersion.V4_0, warnings);
    }

    protected T cannotUnmarshalValue(String value, VCardVersion version, List<String> warnings, U contentType) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                if (value.startsWith("http")) {
                    return this._newInstance(value, contentType);
                }
                value = this.removeWhitespace(value);
                return this._newInstance(Base64.decodeBase64(value), contentType);
            }
            case V4_0: {
                return this._newInstance(value, contentType);
            }
        }
        return null;
    }

    protected abstract U _mediaTypeFromMediaTypeParameter(String var1);

    protected abstract U _mediaTypeFromTypeParameter(String var1);

    protected abstract U _mediaTypeFromFileExtension(String var1);

    protected abstract T _newInstance(String var1, U var2);

    protected abstract T _newInstance(byte[] var1, U var2);

    private U parseContentType(String value, VCardParameters parameters, VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                String type = parameters.getType();
                if (type == null) break;
                return this._mediaTypeFromTypeParameter(type);
            }
            case V4_0: {
                String mediaType = parameters.getMediaType();
                if (mediaType == null) break;
                return this._mediaTypeFromMediaTypeParameter(mediaType);
            }
        }
        String extension = BinaryPropertyScribe.getFileExtension(value);
        return extension == null ? null : (U)this._mediaTypeFromFileExtension(extension);
    }

    private T parse(String value, VCardDataType dataType, VCardParameters parameters, VCardVersion version, List<String> warnings) {
        U contentType = this.parseContentType(value, parameters, version);
        switch (version) {
            case V2_1: 
            case V3_0: {
                if (dataType == VCardDataType.URL || dataType == VCardDataType.URI) {
                    return this._newInstance(value, contentType);
                }
                Encoding encodingSubType = parameters.getEncoding();
                if (encodingSubType != Encoding.BASE64 && encodingSubType != Encoding.B) break;
                value = this.removeWhitespace(value);
                return this._newInstance(Base64.decodeBase64(value), contentType);
            }
            case V4_0: {
                try {
                    DataUri uri = DataUri.parse(value);
                    contentType = this._mediaTypeFromMediaTypeParameter(uri.getContentType());
                    return this._newInstance(uri.getData(), contentType);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        return this.cannotUnmarshalValue(value, version, warnings, contentType);
    }

    private String removeWhitespace(String base64) {
        return base64.replaceAll("[ \\t]", "");
    }

    private String write(T property, VCardVersion version) {
        String url = ((BinaryProperty)property).getUrl();
        if (url != null) {
            return url;
        }
        byte[] data = ((BinaryProperty)property).getData();
        if (data != null) {
            switch (version) {
                case V2_1: 
                case V3_0: {
                    return new String(Base64.encodeBase64(data));
                }
                case V4_0: {
                    Object contentType = ((BinaryProperty)property).getContentType();
                    String mediaType = contentType == null || ((MediaTypeParameter)contentType).getMediaType() == null ? "application/octet-stream" : ((MediaTypeParameter)contentType).getMediaType();
                    return new DataUri(mediaType, data).toString();
                }
            }
        }
        return "";
    }

    protected static String getFileExtension(String url) {
        int dotPos = url.lastIndexOf(46);
        if (dotPos < 0 || dotPos == url.length() - 1) {
            return null;
        }
        int slashPos = url.lastIndexOf(47);
        if (slashPos > dotPos) {
            return null;
        }
        return url.substring(dotPos + 1);
    }
}

