/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.function.Mapper;
import org.magicwerk.brownies.collections.function.Predicate;
import org.magicwerk.brownies.collections.primitive.CharGapList;
import org.magicwerk.brownies.collections.primitive.CharObjGapList;

public abstract class ICharList
implements Cloneable,
Serializable {
    static char[] toArray(Collection<Character> coll) {
        Object[] values = coll.toArray();
        char[] v = new char[values.length];
        for (int i = 0; i < values.length; ++i) {
            v[i] = ((Character)values[i]).charValue();
        }
        return v;
    }

    public ICharList copy() {
        return (ICharList)this.clone();
    }

    public abstract ICharList unmodifiableList();

    public Object clone() {
        try {
            ICharList list = (ICharList)super.clone();
            list.doClone(this);
            return list;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract void doClone(ICharList var1);

    public void clear() {
        this.doRemoveAll(0, this.size());
    }

    public abstract int size();

    public abstract int capacity();

    public char get(int index) {
        this.checkIndex(index);
        return this.doGet(index);
    }

    protected abstract char doGet(int var1);

    protected abstract char doSet(int var1, char var2);

    public char set(int index, char elem) {
        this.checkIndex(index);
        return this.doSet(index, elem);
    }

    protected abstract char doReSet(int var1, char var2);

    protected abstract char getDefaultElem();

    protected void doModify() {
    }

    public boolean add(char elem) {
        return this.doAdd(-1, elem);
    }

    public void add(int index, char elem) {
        this.checkIndexAdd(index);
        this.doAdd(index, elem);
    }

    protected abstract boolean doAdd(int var1, char var2);

    public char remove(int index) {
        this.checkIndex(index);
        return this.doRemove(index);
    }

    protected abstract char doRemove(int var1);

    public void ensureCapacity(int minCapacity) {
        this.doModify();
        this.doEnsureCapacity(minCapacity);
    }

    protected abstract void doEnsureCapacity(int var1);

    public abstract void trimToSize();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CharObjGapList) {
            obj = ((CharObjGapList)obj).list;
        }
        if (!(obj instanceof CharGapList)) {
            return false;
        }
        CharGapList list = (CharGapList)obj;
        int size = this.size();
        if (size != list.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (ICharList.equalsElem(this.doGet(i), list.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            char elem = this.doGet(i);
            hashCode = 31 * hashCode + ICharList.hashCodeElem(elem);
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.doGet(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    static boolean equalsElem(char elem1, char elem2) {
        return elem1 == elem2;
    }

    static int hashCodeElem(char elem) {
        return elem;
    }

    public int getCount(char elem) {
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!ICharList.equalsElem(this.doGet(i), elem)) continue;
            ++count;
        }
        return count;
    }

    public ICharList getAll(char elem) {
        ICharList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            char e = this.doGet(i);
            if (!ICharList.equalsElem(e, elem)) continue;
            list.add(e);
        }
        return list;
    }

    public Set getDistinct() {
        HashSet<Character> set = new HashSet<Character>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            set.add(Character.valueOf(this.doGet(i)));
        }
        return set;
    }

    public <R> IList<R> mappedList(Mapper<Character, R> mapper) {
        int size = this.size();
        GapList<R> mappedList = new GapList<R>(size);
        for (int i = 0; i < size; ++i) {
            char e = this.doGet(i);
            ((IList)mappedList).add(mapper.getKey(Character.valueOf(e)));
        }
        return mappedList;
    }

    public void filter(Predicate<Character> predicate) {
        ICharList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            char e = this.doGet(i);
            if (!predicate.allow(Character.valueOf(e))) continue;
            list.add(e);
        }
        this.doAssign(list);
    }

    public int indexOf(char elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!ICharList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char elem) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!ICharList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeElem(char elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean contains(char elem) {
        return this.indexOf(elem) != -1;
    }

    public boolean containsAny(Collection<Character> coll) {
        for (char elem : coll) {
            if (!this.contains(elem)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Character> coll) {
        for (char elem : coll) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection<Character> coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(Character.valueOf(this.doGet(i)))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public ICharList removeAll(char elem) {
        ICharList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            char e = this.doGet(i);
            if (!ICharList.equalsElem(elem, e)) continue;
            list.add(e);
            this.doRemove(i);
            --size;
            --i;
        }
        return list;
    }

    public boolean removeAll(ICharList coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection<Character> coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(Character.valueOf(this.doGet(i)))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(ICharList coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public char[] toArray() {
        int size = this.size();
        char[] array = new char[size];
        this.doGetAll(array, 0, size);
        return array;
    }

    public char[] toArray(int index, int len) {
        char[] array = new char[len];
        this.doGetAll(array, index, len);
        return array;
    }

    public char[] toArray(char[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (char[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        this.doGetAll(array, 0, size);
        if (array.length > size) {
            array[size] = '\u0000';
        }
        return array;
    }

    protected void doGetAll(char[] array, int index, int len) {
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
    }

    public boolean addAll(Collection<Character> coll) {
        char[] array = ICharList.toArray(coll);
        return this.doAddAll(-1, array);
    }

    public boolean addAll(int index, Collection<Character> coll) {
        this.checkIndexAdd(index);
        char[] array = ICharList.toArray(coll);
        return this.doAddAll(index, array);
    }

    public boolean addAll(char ... elems) {
        return this.doAddAll(-1, elems);
    }

    public boolean addAll(int index, char ... elems) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, elems);
    }

    public boolean addAll(ICharList list) {
        return this.doAddAll(-1, list.toArray());
    }

    public boolean addAll(int index, ICharList list) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, list.toArray());
    }

    protected boolean doAddAll(int index, char[] array) {
        this.doEnsureCapacity(this.size() + array.length);
        if (array.length == 0) {
            return false;
        }
        for (char elem : array) {
            this.doAdd(index, elem);
            if (index == -1) continue;
            ++index;
        }
        return true;
    }

    public char peek() {
        if (this.size() == 0) {
            return '\u0000';
        }
        return this.getFirst();
    }

    public char element() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public char poll() {
        if (this.size() == 0) {
            return '\u0000';
        }
        return this.doRemove(0);
    }

    public char remove() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public boolean offer(char elem) {
        return this.doAdd(-1, elem);
    }

    public char getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public char getLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(size - 1);
    }

    public void addFirst(char elem) {
        this.doAdd(0, elem);
    }

    public void addLast(char elem) {
        this.doAdd(-1, elem);
    }

    public char removeFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public char removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(size - 1);
    }

    public boolean offerFirst(char elem) {
        this.doAdd(0, elem);
        return true;
    }

    public boolean offerLast(char elem) {
        this.doAdd(-1, elem);
        return true;
    }

    public char peekFirst() {
        if (this.size() == 0) {
            return '\u0000';
        }
        return this.doGet(0);
    }

    public char peekLast() {
        int size = this.size();
        if (size == 0) {
            return '\u0000';
        }
        return this.doGet(size - 1);
    }

    public char pollFirst() {
        if (this.size() == 0) {
            return '\u0000';
        }
        return this.doRemove(0);
    }

    public char pollLast() {
        int size = this.size();
        if (size == 0) {
            return '\u0000';
        }
        return this.doRemove(size - 1);
    }

    public char pop() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public void push(char elem) {
        this.doAdd(0, elem);
    }

    public boolean removeFirstOccurrence(char elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean removeLastOccurrence(char elem) {
        int index = this.lastIndexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public static void move(ICharList src, int srcIndex, ICharList dst, int dstIndex, int len) {
        if (src == dst) {
            src.move(srcIndex, dstIndex, len);
        } else {
            src.checkRange(srcIndex, len);
            dst.checkRange(dstIndex, len);
            char defaultElem = src.getDefaultElem();
            for (int i = 0; i < len; ++i) {
                char elem = src.doReSet(srcIndex + i, defaultElem);
                dst.doSet(dstIndex + i, elem);
            }
        }
    }

    public static void copy(ICharList src, int srcIndex, ICharList dst, int dstIndex, int len) {
        if (src == dst) {
            src.copy(srcIndex, dstIndex, len);
        } else {
            src.checkRange(srcIndex, len);
            dst.checkRange(dstIndex, len);
            for (int i = 0; i < len; ++i) {
                char elem = src.doGet(srcIndex + i);
                dst.doSet(dstIndex + i, elem);
            }
        }
    }

    public static void swap(ICharList src, int srcIndex, ICharList dst, int dstIndex, int len) {
        if (src == dst) {
            src.swap(srcIndex, dstIndex, len);
        } else {
            src.checkRange(srcIndex, len);
            dst.checkRange(dstIndex, len);
            if (src != dst) {
                for (int i = 0; i < len; ++i) {
                    char swap = src.doGet(srcIndex + i);
                    swap = dst.doSet(dstIndex + i, swap);
                    src.doSet(srcIndex + i, swap);
                }
            }
        }
    }

    protected abstract ICharList doCreate(int var1);

    protected abstract void doAssign(ICharList var1);

    public ICharList getAll(int index, int len) {
        this.checkRange(index, len);
        ICharList list = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list.add(this.doGet(index + i));
        }
        return list;
    }

    public char[] getArray(int index, int len) {
        this.checkRange(index, len);
        char[] array = new char[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
        return array;
    }

    public void setAll(int index, ICharList list) {
        int size = list.size();
        this.checkRange(index, size);
        for (int i = 0; i < size; ++i) {
            this.doSet(index + i, list.get(i));
        }
    }

    public void setAll(int index, Collection<Character> coll) {
        this.checkRange(index, coll.size());
        int i = 0;
        Iterator<Character> iter = coll.iterator();
        while (iter.hasNext()) {
            this.doSet(index + i, iter.next().charValue());
            ++i;
        }
    }

    public void setAll(int index, char ... elems) {
        this.checkRange(index, elems.length);
        this.doSetAll(index, elems);
    }

    protected void doSetAll(int index, char[] elems) {
        for (int i = 0; i < elems.length; ++i) {
            this.doSet(index + i, elems[i]);
        }
    }

    public void remove(int index, int len) {
        this.checkRange(index, len);
        this.doRemoveAll(index, len);
    }

    protected void doRemoveAll(int index, int len) {
        for (int i = index + len - 1; i >= index; --i) {
            this.doRemove(i);
        }
    }

    public void init(int len, char elem) {
        this.checkLength(len);
        int size = this.size();
        if (len < size) {
            this.remove(len, size - len);
            this.fill(0, len, elem);
        } else {
            this.fill(0, size, elem);
            for (int i = size; i < len; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len);
    }

    public void resize(int len, char elem) {
        this.checkLength(len);
        int size = this.size();
        if (len < size) {
            this.remove(len, size - len);
        } else {
            for (int i = size; i < len; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len);
    }

    public void fill(char elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.doSet(i, elem);
        }
    }

    public void fill(int index, int len, char elem) {
        this.checkRange(index, len);
        for (int i = 0; i < len; ++i) {
            this.doSet(index + i, elem);
        }
    }

    public void copy(int srcIndex, int dstIndex, int len) {
        block3: {
            block2: {
                this.checkRange(srcIndex, len);
                this.checkRange(dstIndex, len);
                if (srcIndex >= dstIndex) break block2;
                for (int i = len - 1; i >= 0; --i) {
                    this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
                }
                break block3;
            }
            if (srcIndex <= dstIndex) break block3;
            for (int i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
    }

    public void move(int srcIndex, int dstIndex, int len) {
        int fill;
        int i;
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            for (i = len - 1; i >= 0; --i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        } else if (srcIndex > dstIndex) {
            for (i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
        if (srcIndex < dstIndex) {
            fill = Math.min(len, dstIndex - srcIndex);
            this.fill(srcIndex, fill, '\u0000');
        } else if (srcIndex > dstIndex) {
            fill = Math.min(len, srcIndex - dstIndex);
            this.fill(srcIndex + len - fill, fill, '\u0000');
        }
    }

    public void reverse() {
        this.reverse(0, this.size());
    }

    public void reverse(int index, int len) {
        this.checkRange(index, len);
        int pos1 = index;
        int pos2 = index + len - 1;
        int mid = len / 2;
        for (int i = 0; i < mid; ++i) {
            char swap = this.doGet(pos1);
            swap = this.doReSet(pos2, swap);
            this.doReSet(pos1, swap);
            ++pos1;
            --pos2;
        }
    }

    public void swap(int index1, int index2, int len) {
        this.checkRange(index1, len);
        this.checkRange(index2, len);
        if (index1 < index2 && index1 + len > index2 || index1 > index2 && index2 + len > index1) {
            throw new IllegalArgumentException("Swap ranges overlap");
        }
        for (int i = 0; i < len; ++i) {
            char swap = this.doGet(index1 + i);
            swap = this.doReSet(index2 + i, swap);
            this.doReSet(index1 + i, swap);
        }
    }

    public void rotate(int distance) {
        this.rotate(0, this.size(), distance);
    }

    public void rotate(int index, int len, int distance) {
        this.checkRange(index, len);
        int size = this.size();
        if ((distance %= size) < 0) {
            distance += size;
        }
        if (distance == 0) {
            return;
        }
        int num = 0;
        int start = 0;
        while (num != size) {
            char elem = this.doGet(index + start);
            int i = start;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                elem = this.doReSet(index + i, elem);
                ++num;
            } while (i != start);
            ++start;
        }
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public abstract void sort(int var1, int var2);

    public int binarySearch(char key) {
        return this.binarySearch(0, this.size(), key);
    }

    public abstract int binarySearch(int var1, int var2, char var3);

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkIndexAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkRange(int index, int len) {
        if (index < 0 || len < 0 || index + len > this.size()) {
            throw new IndexOutOfBoundsException("Invalid range: " + index + "/" + len + " (size: " + this.size() + ")");
        }
    }

    protected void checkLength(int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + length);
        }
    }
}

