/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.data;

import com.openexchange.osgi.data.BundleImport;
import com.openexchange.osgi.data.RequiredBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OSGIManifest {
    public static final String MANIFEST_VERSION = "Manifest-Version";
    public static final String BUNDLE_MANIFEST_VERSION = "Bundle-ManifestVersion";
    public static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    public static final String BUNDLE_LOCALIZATION = "Bundle-Localization";
    public static final String BUNDLE_NAME = "Bundle-Name";
    public static final String BUNDLE_VERSION = "Bundle-Version";
    public static final String BUNDLE_ACTIVATOR = "Bundle-Activator";
    public static final String BUNDLE_DESCRIPTION = "Bundle-Description";
    private static final String REQUIRE_BUNDLE = "Require-Bundle";
    private static final String IMPORT_PACKAGE = "Import-Package";
    private static final String EXPORT_PACKAGE = "Export-Package";
    public static final String EXPORT_SERVICE = "Export-Service";
    public static final String BUNDLE_NATIVE_CODE = "Bundle-NativeCode";
    public static final String FRAGMENT_HOST = "Fragment-Host";
    public static final String BUNDLE_CLASSPATH = "Bundle-ClassPath";
    public static final String CLASS_PATH = "Class-Path";
    protected final Attributes fEntries;
    private final Manifest manifest;
    private static final String IMPORT_REGEX = "([a-z0-9A-Z\\._]+)(?:; ?(?:(?:resolution:=\\\"?(optional)\\\"?)|(?:status=\\\"?(provisional)\\\"?)|(?:version=\\\"?((?:[0-9\\.]+)|(?:[0-9\\.\\[ \\),]+))\\\"?)|(?:password=[^,]+)|(?:bundle-symbolic-name=\\\"?.*?\\\")))*(?:,)?";
    private static final Pattern IMPORT_PATTERN = Pattern.compile("([a-z0-9A-Z\\._]+)(?:; ?(?:(?:resolution:=\\\"?(optional)\\\"?)|(?:status=\\\"?(provisional)\\\"?)|(?:version=\\\"?((?:[0-9\\.]+)|(?:[0-9\\.\\[ \\),]+))\\\"?)|(?:password=[^,]+)|(?:bundle-symbolic-name=\\\"?.*?\\\")))*(?:,)?");
    private static final String REQUIRE_REGEX = "([a-z0-9A-Z\\._]+)(?:; ?(?:(?:resolution:=\"?(optional)\"?)|(?:bundle-version=\\\"((?:[0-9.]+)|(?:[0-9\\.\\[ \\),]+))\\\"?)))*(?:,)?";
    private static final Pattern REQUIRE_PATTERN = Pattern.compile("([a-z0-9A-Z\\._]+)(?:; ?(?:(?:resolution:=\"?(optional)\"?)|(?:bundle-version=\\\"((?:[0-9.]+)|(?:[0-9\\.\\[ \\),]+))\\\"?)))*(?:,)?");
    public static final String EXPORT_REGEX = "([a-z0-9A-Z\\._]+)(?:;\\n? *(?:(?:uses:=\\\"[a-z0-9A-Z\\._]+(?:,\\n? *[a-z0-9A-Z\\._]+)*\\\")|(?:version=\\\"?((?:[0-9\\.\\w]+)|(?:[0-9\\.\\[ \\),]+))\\\"?)|(?:[a-zA-Z-]+:=\\\"[\\w\\.,]+\\\")|(?:[a-zA-Z-]+:?=\\\"?[\\w\\.]+\\\"?)))*(?:,)?";
    private static final Pattern EXPORT_PATTERN = Pattern.compile("([a-z0-9A-Z\\._]+)(?:;\\n? *(?:(?:uses:=\\\"[a-z0-9A-Z\\._]+(?:,\\n? *[a-z0-9A-Z\\._]+)*\\\")|(?:version=\\\"?((?:[0-9\\.\\w]+)|(?:[0-9\\.\\[ \\),]+))\\\"?)|(?:[a-zA-Z-]+:=\\\"[\\w\\.,]+\\\")|(?:[a-zA-Z-]+:?=\\\"?[\\w\\.]+\\\"?)))*(?:,)?");
    private static final String FRAGMENT_REGEX = "([a-z0-9A-Z\\._]+)(?:; ?(?:(?:extension:=\"?(framework)\"?)|(?:bundle-version=\\\"((?:[0-9.]+)|(?:[0-9\\.\\[ \\),]+))\\\"?)))*(?:,)?";
    private static final Pattern FRAGMENT_PATTERN = Pattern.compile("([a-z0-9A-Z\\._]+)(?:; ?(?:(?:extension:=\"?(framework)\"?)|(?:bundle-version=\\\"((?:[0-9.]+)|(?:[0-9\\.\\[ \\),]+))\\\"?)))*(?:,)?");

    public OSGIManifest(File file) throws IOException {
        this(OSGIManifest.readManifest(file));
    }

    public static Manifest readManifest(File file) throws IOException {
        Manifest manifest;
        FileInputStream stream = new FileInputStream(file);
        try {
            manifest = new Manifest(stream);
        }
        finally {
            stream.close();
        }
        return manifest;
    }

    public OSGIManifest(Manifest manifest) {
        this.manifest = manifest;
        this.fEntries = this.manifest.getMainAttributes();
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public String getEntry(String key) {
        String value = this.fEntries.getValue(key);
        if (value != null && value.indexOf(59) != -1) {
            value = value.substring(0, value.indexOf(59));
        }
        return value;
    }

    public Set<BundleImport> getImports() {
        String value = this.fEntries.getValue(IMPORT_PACKAGE);
        HashSet<BundleImport> imports = new HashSet<BundleImport>();
        if (value != null) {
            Matcher matcher = IMPORT_PATTERN.matcher(value);
            while (matcher.find()) {
                String packageName = matcher.group(1);
                boolean optional = "optional".equals(matcher.group(2));
                imports.add(new BundleImport(packageName, optional));
            }
        }
        return imports;
    }

    public Set<RequiredBundle> getRequiredBundles() {
        String value = this.fEntries.getValue(REQUIRE_BUNDLE);
        HashSet<RequiredBundle> requires = new HashSet<RequiredBundle>();
        if (value != null) {
            Matcher matcher = REQUIRE_PATTERN.matcher(value);
            while (matcher.find()) {
                String packageName = matcher.group(1);
                boolean optional = "optional".equals(matcher.group(2));
                requires.add(new RequiredBundle(packageName, optional));
            }
        }
        return requires;
    }

    public Set<String> getExports() {
        String value = this.fEntries.getValue(EXPORT_PACKAGE);
        HashSet<String> exports = new HashSet<String>();
        if (null != value) {
            Matcher matcher = EXPORT_PATTERN.matcher(value);
            while (matcher.find()) {
                exports.add(matcher.group(1));
            }
        }
        return exports;
    }

    public Set<RequiredBundle> getFragmentHost() {
        String value = this.fEntries.getValue(FRAGMENT_HOST);
        HashSet<RequiredBundle> requires = new HashSet<RequiredBundle>();
        if (value != null) {
            Matcher matcher = FRAGMENT_PATTERN.matcher(value);
            while (matcher.find()) {
                String packageName = matcher.group(1);
                requires.add(new RequiredBundle(packageName, false));
            }
        }
        return requires;
    }

    public Set<String> getListEntry(String key) {
        String value = this.fEntries.getValue(key);
        HashSet<String> tokens = new HashSet<String>();
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.indexOf(59) != -1) {
                    token = token.substring(0, token.indexOf(59));
                }
                tokens.add(token.trim());
            }
        }
        return tokens;
    }
}

